/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation.inference;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.dataflow.nullnesspropagation.inference.AutoValue_NullnessQualifierInference_TypeAndSymbol;
import com.google.errorprone.dataflow.nullnesspropagation.inference.InferenceVariable;
import com.google.errorprone.dataflow.nullnesspropagation.inference.InferredNullability;
import com.google.errorprone.dataflow.nullnesspropagation.inference.ProperInferenceVar;
import com.google.errorprone.dataflow.nullnesspropagation.inference.TypeArgInferenceVar;
import com.google.errorprone.dataflow.nullnesspropagation.inference.TypeVariableInferenceVar;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.List;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.lang.model.type.TypeVariable;
import org.jspecify.annotations.Nullable;

public class NullnessQualifierInference
extends TreeScanner<Void, Void> {
    private static final LoadingCache<Tree, InferredNullability> inferenceCache = Caffeine.newBuilder().maximumSize(1L).build((CacheLoader)new CacheLoader<Tree, InferredNullability>(){

        public InferredNullability load(Tree methodOrInitializer) {
            NullnessQualifierInference inferenceEngine = new NullnessQualifierInference(methodOrInitializer);
            inferenceEngine.scan(methodOrInitializer, null);
            return new InferredNullability((Graph<InferenceVariable>)inferenceEngine.qualifierConstraints);
        }
    });
    private final MutableGraph<InferenceVariable> qualifierConstraints;
    private final Tree currentMethodOrInitializerOrLambda;

    public static InferredNullability getInferredNullability(Tree methodOrInitializerOrLambda) {
        Preconditions.checkArgument((methodOrInitializerOrLambda instanceof MethodTree || methodOrInitializerOrLambda instanceof LambdaExpressionTree || methodOrInitializerOrLambda instanceof BlockTree || methodOrInitializerOrLambda instanceof VariableTree ? 1 : 0) != 0, (String)"Tree `%s` is not a lambda, initializer, or method.", (Object)methodOrInitializerOrLambda);
        return (InferredNullability)inferenceCache.get((Object)methodOrInitializerOrLambda);
    }

    private NullnessQualifierInference(Tree currentMethodOrInitializerOrLambda) {
        this.currentMethodOrInitializerOrLambda = currentMethodOrInitializerOrLambda;
        this.qualifierConstraints = GraphBuilder.directed().build();
        this.qualifierConstraints.putEdge((Object)ProperInferenceVar.BOTTOM, (Object)ProperInferenceVar.NONNULL);
        this.qualifierConstraints.putEdge((Object)ProperInferenceVar.BOTTOM, (Object)ProperInferenceVar.NULL);
        this.qualifierConstraints.putEdge((Object)ProperInferenceVar.NONNULL, (Object)ProperInferenceVar.NULLABLE);
        this.qualifierConstraints.putEdge((Object)ProperInferenceVar.NULL, (Object)ProperInferenceVar.NULLABLE);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void unused) {
        Symbol sym = ((JCTree.JCIdent)node).sym;
        if (sym instanceof Symbol.VarSymbol) {
            Type declaredType = sym.type;
            this.generateConstraintsFromAnnotations(((JCTree.JCIdent)node).type, sym, declaredType, node, new ArrayDeque<Integer>());
        }
        return (Void)super.visitIdentifier(node, null);
    }

    private void generateConstraintsFromAnnotations(Type inferredType, @Nullable Symbol decl, @Nullable Type declaredType, Tree sourceTree, ArrayDeque<Integer> argSelector) {
        List<Type> inferredTypeArguments = inferredType.getTypeArguments();
        List<Type> declaredTypeArguments = declaredType != null ? declaredType.getTypeArguments() : ImmutableList.of();
        int numberOfTypeArgs = inferredTypeArguments.size();
        for (int i = 0; i < numberOfTypeArgs; ++i) {
            argSelector.push(i);
            this.generateConstraintsFromAnnotations((Type)inferredTypeArguments.get(i), decl, i < declaredTypeArguments.size() ? (Type)declaredTypeArguments.get(i) : null, sourceTree, argSelector);
            argSelector.pop();
        }
        Optional<Nullness> fromAnnotations = NullnessQualifierInference.extractExplicitNullness(declaredType, argSelector.isEmpty() ? decl : null);
        if (!fromAnnotations.isPresent()) {
            fromAnnotations = NullnessAnnotations.fromAnnotationsOn(inferredType);
        }
        if (!fromAnnotations.isPresent()) {
            fromAnnotations = declaredType instanceof TypeVariable ? NullnessAnnotations.getUpperBound((TypeVariable)((Object)declaredType)) : NullnessAnnotations.fromDefaultAnnotations(decl);
        }
        fromAnnotations.map(ProperInferenceVar::create).ifPresent(annot -> {
            TypeArgInferenceVar var = TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.copyOf((Collection)argSelector), sourceTree);
            this.qualifierConstraints.putEdge((Object)var, annot);
            this.qualifierConstraints.putEdge(annot, (Object)var);
        });
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void unused) {
        Type lhsType = node.getVariable() instanceof ArrayAccessTree ? ((JCTree.JCArrayAccess)node.getVariable()).getExpression().type : TreeInfo.symbol((JCTree)((JCTree)((Object)node.getVariable()))).type;
        this.generateConstraintsForWrite(lhsType, null, node.getExpression(), node);
        return (Void)super.visitAssignment(node, null);
    }

    @Override
    public Void visitVariable(VariableTree node, Void unused) {
        if (node.getInitializer() != null) {
            Symbol symbol = TreeInfo.symbolFor((JCTree)((Object)node));
            this.generateConstraintsForWrite(symbol.type, symbol, node.getInitializer(), node);
        }
        return (Void)super.visitVariable(node, null);
    }

    @Override
    public Void visitReturn(ReturnTree node, Void unused) {
        if (node.getExpression() != null && this.currentMethodOrInitializerOrLambda instanceof MethodTree) {
            Symbol.MethodSymbol sym = (Symbol.MethodSymbol)TreeInfo.symbolFor((JCTree)this.currentMethodOrInitializerOrLambda);
            this.generateConstraintsForWrite(sym.getReturnType(), sym, node.getExpression(), node);
        }
        return (Void)super.visitReturn(node, null);
    }

    private static ImmutableList<TypeAndSymbol> expandVarargsToArity(java.util.List<Symbol.VarSymbol> formalArgs, int arity) {
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)arity);
        int numberOfVarArgs = arity - formalArgs.size() + 1;
        Iterator<Symbol.VarSymbol> argsIterator = formalArgs.iterator();
        while (argsIterator.hasNext()) {
            Symbol.VarSymbol arg = argsIterator.next();
            if (argsIterator.hasNext()) {
                result.add((Object)TypeAndSymbol.create(arg.type, arg));
                continue;
            }
            Type varArgType = ((Type.ArrayType)arg.type).elemtype;
            for (int idx = 0; idx < numberOfVarArgs; ++idx) {
                result.add((Object)TypeAndSymbol.create(varArgType));
            }
        }
        return result.build();
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
        JCTree.JCMethodInvocation sourceNode = (JCTree.JCMethodInvocation)node;
        Symbol.MethodSymbol callee = (Symbol.MethodSymbol)TreeInfo.symbol(sourceNode.getMethodSelect());
        ImmutableList formalParameters = callee.isVarArgs() ? NullnessQualifierInference.expandVarargsToArity(callee.getParameters(), sourceNode.args.size()) : (ImmutableList)callee.getParameters().stream().map(var -> TypeAndSymbol.create(var.type, var)).collect(ImmutableList.toImmutableList());
        Streams.forEachPair((Stream)formalParameters.stream(), sourceNode.getArguments().stream(), (formal, actual) -> this.generateConstraintsForWrite(formal.type(), formal.symbol(), (ExpressionTree)actual, null));
        this.generateConstraintsFromAnnotations(sourceNode.type, callee, callee.getReturnType(), sourceNode, new ArrayDeque<Integer>());
        if (!callee.isStatic() && node.getMethodSelect() instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node.getMethodSelect();
            for (Symbol.TypeVariableSymbol tvs : fieldAccess.selected.type.tsym.getTypeParameters()) {
                Type rcvrtype = fieldAccess.selected.type.tsym.type;
                ImmutableSet<InferenceVariable> rcvrReferences = NullnessQualifierInference.findUnannotatedTypeVarRefs(tvs, rcvrtype, null, fieldAccess.selected);
                Type restype = fieldAccess.sym.type.asMethodType().restype;
                NullnessQualifierInference.findUnannotatedTypeVarRefs(tvs, restype, fieldAccess.sym, node).forEach(resRef -> rcvrReferences.forEach(rcvrRef -> this.qualifierConstraints.putEdge(resRef, rcvrRef)));
                Streams.forEachPair((Stream)formalParameters.stream(), node.getArguments().stream(), (formal, actual) -> NullnessQualifierInference.findUnannotatedTypeVarRefs(tvs, formal.type(), formal.symbol(), actual).forEach(argRef -> rcvrReferences.forEach(rcvrRef -> this.qualifierConstraints.putEdge(argRef, rcvrRef))));
            }
        }
        for (Symbol.TypeVariableSymbol typeVar : callee.getTypeParameters()) {
            TypeVariableInferenceVar typeVarIv = TypeVariableInferenceVar.create(typeVar, node);
            this.visitUnannotatedTypeVarRefsAndEquateInferredComponents(typeVarIv, callee.getReturnType(), callee, node, iv -> this.qualifierConstraints.putEdge((Object)typeVarIv, iv));
            Streams.forEachPair((Stream)formalParameters.stream(), node.getArguments().stream(), (formal, actual) -> this.visitUnannotatedTypeVarRefsAndEquateInferredComponents(typeVarIv, formal.type(), formal.symbol(), (Tree)actual, iv -> this.qualifierConstraints.putEdge(iv, (Object)typeVarIv)));
        }
        return (Void)super.visitMethodInvocation(node, null);
    }

    private static void visitTypeVarRefs(Symbol.TypeVariableSymbol typeVar, Type declaredType, ArrayDeque<Integer> partialSelector, @Nullable Type inferredType, TypeComponentConsumer consumer) {
        List<Type> declaredTypeArguments = declaredType.getTypeArguments();
        List<Type> inferredTypeArguments = inferredType != null ? inferredType.getTypeArguments() : ImmutableList.of();
        for (int i = 0; i < declaredTypeArguments.size(); ++i) {
            partialSelector.push(i);
            NullnessQualifierInference.visitTypeVarRefs(typeVar, (Type)declaredTypeArguments.get(i), partialSelector, i < inferredTypeArguments.size() ? (Type)inferredTypeArguments.get(i) : null, consumer);
            partialSelector.pop();
        }
        if (declaredType.tsym.equals(typeVar)) {
            consumer.accept(declaredType, partialSelector, inferredType);
        }
    }

    private static ImmutableSet<InferenceVariable> findUnannotatedTypeVarRefs(Symbol.TypeVariableSymbol typeVar, Type declaredType, @Nullable Symbol decl, Tree sourceNode) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        NullnessQualifierInference.visitTypeVarRefs(typeVar, declaredType, new ArrayDeque<Integer>(), null, (typeVarRef, selector, unused) -> {
            if (!NullnessQualifierInference.extractExplicitNullness(typeVarRef, selector.isEmpty() ? decl : null).isPresent()) {
                result.add((Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.copyOf((Collection)selector), sourceNode));
            }
        });
        return result.build();
    }

    private void visitUnannotatedTypeVarRefsAndEquateInferredComponents(TypeVariableInferenceVar typeVar, Type type, @Nullable Symbol decl, Tree sourceNode, Consumer<TypeArgInferenceVar> consumer) {
        NullnessQualifierInference.visitTypeVarRefs(typeVar.typeVar(), type, new ArrayDeque<Integer>(), ((JCTree.JCExpression)sourceNode).type, (declaredType, selector, inferredType) -> {
            if (!NullnessQualifierInference.extractExplicitNullness(type, selector.isEmpty() ? decl : null).isPresent()) {
                consumer.accept(TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.copyOf((Collection)selector), sourceNode));
            }
            if (inferredType == null) {
                return;
            }
            List<Type> typeArguments = inferredType.getTypeArguments();
            int depth = selector.size();
            for (int i = 0; i < typeArguments.size(); ++i) {
                selector.push(i);
                NullnessQualifierInference.visitTypeComponents((Type)typeArguments.get(i), selector, sourceNode, typeArg -> {
                    TypeVariableInferenceVar typeVarComponent = typeVar.withSelector((ImmutableList<Integer>)typeArg.typeArgSelector().subList(depth, typeArg.typeArgSelector().size()));
                    this.qualifierConstraints.putEdge((Object)typeVarComponent, typeArg);
                    this.qualifierConstraints.putEdge(typeArg, (Object)typeVarComponent);
                });
                selector.pop();
            }
        });
    }

    private static void visitTypeComponents(Type type, ArrayDeque<Integer> partialSelector, Tree sourceNode, Consumer<TypeArgInferenceVar> consumer) {
        List<Type> typeArguments = type.getTypeArguments();
        for (int i = 0; i < typeArguments.size(); ++i) {
            partialSelector.push(i);
            NullnessQualifierInference.visitTypeComponents((Type)typeArguments.get(i), partialSelector, sourceNode, consumer);
            partialSelector.pop();
        }
        consumer.accept(TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.copyOf(partialSelector), sourceNode));
    }

    private static Optional<Nullness> extractExplicitNullness(@Nullable Type type, @Nullable Symbol symbol) {
        Optional<Nullness> result;
        if (symbol != null && (result = NullnessAnnotations.fromAnnotationsOn(symbol)).isPresent()) {
            return result;
        }
        return NullnessAnnotations.fromAnnotationsOn(type);
    }

    private void generateConstraintsForWrite(Type lType, @Nullable Symbol decl, ExpressionTree rVal, @Nullable Tree lVal) {
        if (rVal.getKind() == Tree.Kind.NULL_LITERAL) {
            this.qualifierConstraints.putEdge((Object)ProperInferenceVar.NULL, (Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.of(), rVal));
            this.qualifierConstraints.putEdge((Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.of(), rVal), (Object)ProperInferenceVar.NULL);
        } else if (rVal instanceof LiteralTree || rVal instanceof NewClassTree || rVal instanceof NewArrayTree || rVal instanceof IdentifierTree && ((IdentifierTree)rVal).getName().contentEquals("this")) {
            this.qualifierConstraints.putEdge((Object)ProperInferenceVar.NONNULL, (Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.of(), rVal));
            this.qualifierConstraints.putEdge((Object)TypeArgInferenceVar.create((ImmutableList<Integer>)ImmutableList.of(), rVal), (Object)ProperInferenceVar.NONNULL);
        }
        this.generateConstraintsForWrite(lType, decl, rVal, lVal, new ArrayDeque<Integer>());
    }

    private void generateConstraintsForWrite(Type lType, @Nullable Symbol decl, ExpressionTree rVal, @Nullable Tree lVal, ArrayDeque<Integer> argSelector) {
        List<Type> typeArguments = lType.getTypeArguments();
        for (int i = 0; i < typeArguments.size(); ++i) {
            argSelector.push(i);
            this.generateConstraintsForWrite((Type)typeArguments.get(i), decl, rVal, lVal, argSelector);
            argSelector.pop();
        }
        ImmutableList argSelectorList = ImmutableList.copyOf(argSelector);
        boolean isBound = false;
        Optional<Nullness> fromAnnotations = NullnessQualifierInference.extractExplicitNullness(lType, argSelector.isEmpty() ? decl : null);
        if (!fromAnnotations.isPresent()) {
            if (lType instanceof TypeVariable) {
                fromAnnotations = NullnessAnnotations.getUpperBound((TypeVariable)((Object)lType));
                isBound = true;
            } else {
                fromAnnotations = NullnessAnnotations.fromDefaultAnnotations(decl);
            }
        }
        boolean oneSided = isBound || argSelector.isEmpty();
        fromAnnotations.map(ProperInferenceVar::create).ifPresent(annot -> {
            TypeArgInferenceVar var = TypeArgInferenceVar.create((ImmutableList<Integer>)argSelectorList, rVal);
            this.qualifierConstraints.putEdge((Object)var, annot);
            if (!oneSided) {
                this.qualifierConstraints.putEdge(annot, (Object)var);
            }
        });
        if (lVal != null) {
            this.qualifierConstraints.putEdge((Object)TypeArgInferenceVar.create((ImmutableList<Integer>)argSelectorList, rVal), (Object)TypeArgInferenceVar.create((ImmutableList<Integer>)argSelectorList, lVal));
        }
    }

    @AutoValue
    static abstract class TypeAndSymbol {
        TypeAndSymbol() {
        }

        static TypeAndSymbol create(Type type) {
            return TypeAndSymbol.create(type, null);
        }

        static TypeAndSymbol create(Type type, @Nullable Symbol.VarSymbol symbol) {
            return new AutoValue_NullnessQualifierInference_TypeAndSymbol(type, symbol);
        }

        abstract Type type();

        abstract @Nullable Symbol.VarSymbol symbol();
    }

    @FunctionalInterface
    private static interface TypeComponentConsumer {
        public void accept(Type var1, ArrayDeque<Integer> var2, @Nullable Type var3);
    }
}

