/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.inject.Inject;

final class AnnotationExclusionStrategy
implements ExclusionStrategy {
    @Inject
    AnnotationExclusionStrategy() {
    }

    public boolean shouldSkipField(FieldAttributes f) {
        return AnnotationExclusionStrategy.excludeFromJson(f.getAnnotations());
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        return AnnotationExclusionStrategy.excludeFromJson(Arrays.asList(clazz.getAnnotations()));
    }

    private static boolean excludeFromJson(Iterable<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getSimpleName().equals("ExcludeFromJson")) continue;
            return true;
        }
        return false;
    }
}

