/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.worker.Allocation;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import java.util.Comparator;

final class AllocationStats {
    private final int allocationCount;
    private final long allocationSize;
    private final int reps;
    private final ImmutableMultiset<Allocation> allocations;

    AllocationStats(int allocationCount, long allocationSize, int reps) {
        this(allocationCount, allocationSize, reps, (Multiset<Allocation>)ImmutableMultiset.of());
    }

    AllocationStats(Multiset<Allocation> allocations, int reps) {
        this(allocations.size(), Allocation.getTotalSize(allocations), reps, allocations);
    }

    private AllocationStats(int allocationCount, long allocationSize, int reps, Multiset<Allocation> allocations) {
        Preconditions.checkArgument((allocationCount >= 0 ? 1 : 0) != 0, (String)"allocationCount (%s) was negative", (int)allocationCount);
        this.allocationCount = allocationCount;
        Preconditions.checkArgument((allocationSize >= 0L ? 1 : 0) != 0, (String)"allocationSize (%s) was negative", (long)allocationSize);
        this.allocationSize = allocationSize;
        Preconditions.checkArgument((reps >= 0 ? 1 : 0) != 0, (String)"reps (%s) was negative", (int)reps);
        this.reps = reps;
        this.allocations = ImmutableMultiset.copyOf(allocations);
    }

    int getAllocationCount() {
        return this.allocationCount;
    }

    long getAllocationSize() {
        return this.allocationSize;
    }

    AllocationStats minus(AllocationStats baseline) {
        for (Multiset.Entry entry : baseline.allocations.entrySet()) {
            int superCount = this.allocations.count(entry.getElement());
            if (superCount >= entry.getCount()) continue;
            throw new IllegalStateException(String.format("Your benchmark appears to have non-deterministic allocation behavior. Observed %d instance(s) of %s in the baseline but only %d in the actual measurement", entry.getCount(), entry.getElement(), superCount));
        }
        try {
            return new AllocationStats(this.allocationCount - baseline.allocationCount, this.allocationSize - baseline.allocationSize, this.reps - baseline.reps, (Multiset<Allocation>)Multisets.difference(this.allocations, baseline.allocations));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Your benchmark appears to have non-deterministic allocation behavior. The difference between the baseline %s and the measurement %s is invalid. Consider enabling instrument.allocation.options.trackAllocations to get a more specific error message.", baseline, this), e);
        }
    }

    public Delta delta(AllocationStats baseline) {
        return new Delta(this.allocationCount - baseline.allocationCount, this.allocationSize - baseline.allocationSize, this.reps - baseline.reps, (Multiset<Allocation>)Multisets.difference(this.allocations, baseline.allocations), (Multiset<Allocation>)Multisets.difference(baseline.allocations, this.allocations));
    }

    ImmutableList<Measurement> toMeasurements() {
        this.allocations.entrySet().stream().sorted(Comparator.comparing(e -> e.getCount()).reversed().thenComparing(Multiset.Entry::getElement, Comparator.comparing(Allocation::getSize).reversed().thenComparing(Allocation::getDescription).thenComparing(Allocation::getLocation, Ordering.natural().lexicographical()))).forEach(entry -> {
            double allocsPerRep = (double)entry.getCount() / (double)this.reps;
            System.out.printf("Allocated %f allocs per rep of %s%n", allocsPerRep, entry.getElement());
        });
        return ImmutableList.of((Object)new Measurement.Builder().value(Value.create((double)this.allocationCount, (String)"")).description("objects").weight((double)this.reps).build(), (Object)new Measurement.Builder().value(Value.create((double)this.allocationSize, (String)"B")).weight((double)this.reps).description("bytes").build());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AllocationStats) {
            AllocationStats that = (AllocationStats)obj;
            return this.allocationCount == that.allocationCount && this.allocationSize == that.allocationSize && this.reps == that.reps && Objects.equal(this.allocations, that.allocations);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.allocationCount, this.allocationSize, this.reps, this.allocations});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("allocationCount", this.allocationCount).add("allocationSize", this.allocationSize).add("reps", this.reps).add("allocations", this.allocations).toString();
    }

    static final class Delta {
        private final int count;
        private final long size;
        private final int reps;
        private final Multiset<Allocation> additions;
        private final Multiset<Allocation> removals;

        Delta(int count, long size, int reps, Multiset<Allocation> additions, Multiset<Allocation> removals) {
            this.count = count;
            this.size = size;
            this.reps = reps;
            this.additions = additions;
            this.removals = removals;
        }

        private static String formatWithLeadingSign(long n) {
            return n > 0L ? new StringBuilder(21).append("+").append(n).toString() : new StringBuilder(20).append(n).toString();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", (Object)Delta.formatWithLeadingSign(this.count)).add("size", (Object)Delta.formatWithLeadingSign(this.size)).add("reps", (Object)Delta.formatWithLeadingSign(this.reps)).add("additions", this.additions).add("removals", this.removals).toString();
        }
    }
}

