/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.List;

final class Allocation {
    private final String description;
    private final long size;
    private final ImmutableList<String> location;

    static long getTotalSize(Multiset<Allocation> allocations) {
        long totalSize = 0L;
        for (Multiset.Entry allocation : allocations.entrySet()) {
            totalSize += ((Allocation)allocation.getElement()).size * (long)allocation.getCount();
        }
        return totalSize;
    }

    Allocation(String description, long size, List<StackTraceElement> location) {
        this.description = description.intern();
        this.size = size;
        ImmutableList.Builder locationBuilder = ImmutableList.builder();
        for (StackTraceElement ste : location) {
            locationBuilder.add((Object)ste.toString().intern());
        }
        this.location = locationBuilder.build();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Allocation) {
            Allocation other = (Allocation)obj;
            return other.description.equals(this.description) && other.size == this.size && other.location.equals(this.location);
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public long getSize() {
        return this.size;
    }

    public ImmutableList<String> getLocation() {
        return this.location;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description, this.size, this.location});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.description).append(" (").append(this.size).append(" bytes)\n\tat ");
        Joiner.on((String)"\n\tat ").appendTo(builder, this.location);
        return builder.toString();
    }
}

