/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;

public final class WellKnownThreadSafety
implements ThreadSafety.KnownTypes {
    private final ImmutableMap<String, AnnotationInfo> knownThreadSafeClasses;
    private final ImmutableSet<String> knownUnsafeClasses;

    @Inject
    WellKnownThreadSafety(ErrorProneFlags flags, WellKnownMutability wellKnownMutability) {
        ImmutableList knownThreadSafe = flags.getListOrEmpty("ThreadSafe:KnownThreadSafe");
        this.knownThreadSafeClasses = WellKnownThreadSafety.buildThreadSafeClasses((List<String>)knownThreadSafe, wellKnownMutability);
        this.knownUnsafeClasses = wellKnownMutability.getKnownMutableClasses();
    }

    public static WellKnownThreadSafety fromFlags(ErrorProneFlags flags) {
        return new WellKnownThreadSafety(flags, WellKnownMutability.fromFlags(flags));
    }

    public ImmutableMap<String, AnnotationInfo> getKnownThreadSafeClasses() {
        return this.knownThreadSafeClasses;
    }

    @Override
    public ImmutableMap<String, AnnotationInfo> getKnownSafeClasses() {
        return this.getKnownThreadSafeClasses();
    }

    @Override
    public ImmutableSet<String> getKnownUnsafeClasses() {
        return this.knownUnsafeClasses;
    }

    private static ImmutableMap<String, AnnotationInfo> buildThreadSafeClasses(List<String> extraKnownThreadSafe, WellKnownMutability mutability) {
        return new ThreadSafety.KnownTypes.MapBuilder().addAll(mutability.getKnownImmutableClasses()).addStrings(extraKnownThreadSafe).add(ClassLoader.class, new String[0]).add(Thread.class, new String[0]).add(Random.class, new String[0]).add(AtomicBoolean.class, new String[0]).add(AtomicInteger.class, new String[0]).add(AtomicIntegerArray.class, new String[0]).add(AtomicLong.class, new String[0]).add(AtomicLongArray.class, new String[0]).add(AtomicMarkableReference.class, new String[0]).add(AtomicReference.class, "V").add(DoubleAccumulator.class, new String[0]).add(DoubleAdder.class, new String[0]).add(LongAccumulator.class, new String[0]).add(LongAdder.class, new String[0]).add(BlockingDeque.class, "E").add(BlockingQueue.class, "E").add(LinkedBlockingDeque.class, "E").add(LinkedBlockingQueue.class, "E").add(PriorityBlockingQueue.class, "E").add(ConcurrentLinkedDeque.class, "E").add(ConcurrentLinkedQueue.class, "E").add(ConcurrentHashMap.class, "K", "V").add(ConcurrentMap.class, "K", "V").add(ConcurrentNavigableMap.class, "K", "V").add(ConcurrentSkipListMap.class, "K", "V").add(ConcurrentSkipListSet.class, "E").add(CopyOnWriteArrayList.class, "E").add(CopyOnWriteArraySet.class, "E").add(CountDownLatch.class, new String[0]).add(Executor.class, new String[0]).add(ExecutorService.class, new String[0]).add(Future.class, "V").add(CompletableFuture.class, "T").add(Semaphore.class, new String[0]).add(ScheduledExecutorService.class, new String[0]).add(Condition.class, new String[0]).add(Lock.class, new String[0]).add(ReadWriteLock.class, new String[0]).add(ReentrantLock.class, new String[0]).add(ReentrantReadWriteLock.class, new String[0]).add(X509Certificate.class, new String[0]).add(TrustAnchor.class, new String[0]).add(SecureRandom.class, new String[0]).add("com.google.common.base.Ticker", new String[0]).add("com.google.common.testing.FakeTicker", new String[0]).add("com.google.common.time.Clock", new String[0]).add("com.google.common.time.TimeSource", new String[0]).add("com.google.common.util.concurrent.AtomicLongMap", "K").add("com.google.common.util.concurrent.CheckedFuture", "V", "X").add("com.google.common.util.concurrent.ListeningExecutorService", new String[0]).add("com.google.common.util.concurrent.ListenableFuture", "V").add("com.google.common.util.concurrent.ListeningScheduledExecutorService", new String[0]).add("com.google.common.util.concurrent.RateLimiter", new String[0]).add("com.google.common.util.concurrent.RateObserver", new String[0]).add("com.google.common.util.concurrent.SettableFuture", "V").add("com.google.common.util.concurrent.Striped", "L").add("com.google.common.cache.LoadingCache", "K", "V").add("com.google.common.cache.AsyncLoadingCache", "K", "V").add("com.google.common.cache.Cache", "K", "V").add("com.google.common.collect.ConcurrentHashMultiset", "E").add("dagger.Lazy", "T").add("org.reactivestreams.Publisher", "T").add("org.reactivestreams.Processor", "T", "R").add("io.reactivex.Maybe", "T").add("io.reactivex.Single", "T").add("io.reactivex.Flowable", "T").add(Throwable.class, new String[0]).add("java.lang.ThreadLocal", new String[0]).add("java.lang.invoke.MethodHandle", new String[0]).add(Method.class, new String[0]).add(Field.class, new String[0]).add("com.github.benmanes.caffeine.cache.Cache", "K", "V").add("com.github.benmanes.caffeine.cache.AsyncCache", "K", "V").add("com.github.benmanes.caffeine.cache.LoadingCache", "K", "V").add("com.github.benmanes.caffeine.cache.AsyncLoadingCache", "K", "V").add("com.github.benmanes.caffeine.cache.stats.ConcurrentStatsCounter", new String[0]).add("kotlinx.coroutines.CoroutineDispatcher", new String[0]).add("kotlinx.coroutines.CoroutineScope", new String[0]).add("kotlinx.coroutines.ExecutorCoroutineDispatcher", new String[0]).add("kotlinx.coroutines.flow.Flow", "T").add("kotlinx.coroutines.flow.SharedFlow", "T").add("kotlinx.coroutines.flow.MutableSharedFlow", "T").add("kotlinx.coroutines.flow.StateFlow", "T").add("kotlinx.coroutines.flow.MutableStateFlow", "T").add("kotlinx.coroutines.sync.Mutex", new String[0]).add("kotlinx.coroutines.sync.Semaphore", new String[0]).add("kotlin.Result", "T").add("kotlin.Unit", new String[0]).add("org.bouncycastle.cms.CMSSignedData", new String[0]).add("org.bouncycastle.pkcs.PKCS10CertificationRequest", new String[0]).build();
    }
}

