/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.Objects;

@BugPattern(summary="System.console() no longer returns null in JDK 22 and newer versions", severity=BugPattern.SeverityLevel.WARNING)
public class SystemConsoleNull
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.lang.System").named("console");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol sym;
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Tree enclosing = state.getPath().getParentPath().getLeaf();
        if (SystemConsoleNull.isNullCheck(enclosing)) {
            return this.describeMatch(enclosing, (Fix)SystemConsoleNull.buildFix(enclosing));
        }
        if (enclosing instanceof VariableTree && Objects.equals(((VariableTree)enclosing).getInitializer(), tree) && ASTHelpers.isConsideredFinal((Symbol)(sym = ASTHelpers.getSymbol((Tree)enclosing)))) {
            new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
                final /* synthetic */ SystemConsoleNull this$0;
                {
                    this.this$0 = this$0;
                    super((BugChecker)this$0, state);
                }

                public Void visitIdentifier(IdentifierTree tree, Void unused) {
                    Tree enclosing;
                    if (sym.equals(ASTHelpers.getSymbol((Tree)tree)) && SystemConsoleNull.isNullCheck(enclosing = this.getCurrentPath().getParentPath().getLeaf())) {
                        this.state.reportMatch(this.this$0.describeMatch(tree, (Fix)SystemConsoleNull.buildFix(enclosing, tree, this.state)));
                    }
                    return null;
                }
            }.scan((Tree)state.getPath().getCompilationUnit(), null);
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix buildFix(Tree enclosing) {
        return SuggestedFix.emptyFix();
    }

    private static SuggestedFix buildFix(Tree enclosing, IdentifierTree identifier, VisitorState state) {
        return SuggestedFix.emptyFix();
    }

    private static boolean isNullCheck(Tree tree) {
        if (!(tree instanceof BinaryTree)) {
            return false;
        }
        BinaryTree binaryTree = (BinaryTree)tree;
        switch (binaryTree.getKind()) {
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                break;
            }
            default: {
                return false;
            }
        }
        return binaryTree.getLeftOperand().getKind().equals((Object)Tree.Kind.NULL_LITERAL) || binaryTree.getRightOperand().getKind().equals((Object)Tree.Kind.NULL_LITERAL);
    }
}

