/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.protobuf.ByteString;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Detects calls that will fail at runtime", severity=BugPattern.SeverityLevel.ERROR)
public class AlwaysThrows
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableMap<String, Consumer<CharSequence>> VALIDATORS = ImmutableMap.builder().put((Object)"java.time.Duration", Duration::parse).put((Object)"java.time.Instant", Instant::parse).put((Object)"java.time.LocalDate", LocalDate::parse).put((Object)"java.time.LocalDateTime", LocalDateTime::parse).put((Object)"java.time.LocalTime", LocalTime::parse).put((Object)"java.time.MonthDay", MonthDay::parse).put((Object)"java.time.OffsetDateTime", OffsetDateTime::parse).put((Object)"java.time.OffsetTime", OffsetTime::parse).put((Object)"java.time.Period", Period::parse).put((Object)"java.time.Year", Year::parse).put((Object)"java.time.YearMonth", YearMonth::parse).put((Object)"java.time.ZonedDateTime", ZonedDateTime::parse).buildOrThrow();
    private static final Matcher<ExpressionTree> IMMUTABLE_MAP_OF = MethodMatchers.staticMethod().onDescendantOf("com.google.common.collect.ImmutableMap").named("of");
    private static final Matcher<ExpressionTree> IMMUTABLE_BI_MAP_OF = MethodMatchers.staticMethod().onDescendantOf("com.google.common.collect.ImmutableBiMap").named("of");
    private static final Matcher<ExpressionTree> IMMUTABLE_MAP_PUT = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.collect.ImmutableMap.Builder").namedAnyOf(new String[]{"put"}).withParameters("java.lang.Object", new String[]{"java.lang.Object"});
    private static final Matcher<ExpressionTree> IMMUTABLE_BI_MAP_PUT = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.collect.ImmutableBiMap.Builder").namedAnyOf(new String[]{"put"}).withParameters("java.lang.Object", new String[]{"java.lang.Object"});
    private final ConstantExpressions constantExpressions;

    @Inject
    AlwaysThrows(ConstantExpressions constantExpressions) {
        this.constantExpressions = constantExpressions;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Api api;
        Description description;
        if (IMMUTABLE_MAP_PUT.matches((Tree)tree, state)) {
            Tree grandParent;
            if (state.getPath().getParentPath() != null && state.getPath().getParentPath().getParentPath() != null && (grandParent = state.getPath().getParentPath().getParentPath().getLeaf()) instanceof ExpressionTree && IMMUTABLE_MAP_PUT.matches((Tree)((ExpressionTree)grandParent), state)) {
                return Description.NO_MATCH;
            }
            description = this.checkImmutableMapBuilder(tree, 0, state);
            if (!description.equals(Description.NO_MATCH)) {
                return description;
            }
            if (IMMUTABLE_BI_MAP_PUT.matches((Tree)tree, state)) {
                return this.checkImmutableMapBuilder(tree, 1, state);
            }
        }
        if (IMMUTABLE_MAP_OF.matches((Tree)tree, state)) {
            description = this.checkImmutableMapOf(tree, 0, state);
            if (!description.equals(Description.NO_MATCH)) {
                return description;
            }
            if (IMMUTABLE_BI_MAP_OF.matches((Tree)tree, state)) {
                return this.checkImmutableMapOf(tree, 1, state);
            }
        }
        if ((api = (Api)Arrays.stream(Api.values()).filter(m -> m.matcher.matches((Tree)tree, state)).findAny().orElse(null)) == null) {
            return Description.NO_MATCH;
        }
        String argument = (String)ASTHelpers.constValue((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments())), String.class);
        if (argument == null) {
            return Description.NO_MATCH;
        }
        try {
            api.validate(tree, argument);
        }
        catch (Exception t) {
            return this.buildDescription(tree).setMessage(String.format("This call will fail at runtime with a %s: %s", t.getClass().getSimpleName(), t.getMessage())).build();
        }
        return Description.NO_MATCH;
    }

    private Description checkImmutableMapBuilder(MethodInvocationTree tree, int index, VisitorState state) {
        HashMultiset keys = HashMultiset.create();
        ExpressionTree receiver = tree;
        while (receiver instanceof MethodInvocationTree && IMMUTABLE_MAP_PUT.matches((Tree)receiver, state)) {
            Object constantKey = this.getConstantKey(receiver.getArguments().get(index), state);
            if (constantKey != null) {
                keys.add(constantKey);
            }
            receiver = ASTHelpers.getReceiver((ExpressionTree)receiver);
        }
        return this.checkForRepeatedKeys(tree, (Multiset<Object>)keys);
    }

    private Description checkImmutableMapOf(MethodInvocationTree tree, int index, VisitorState state) {
        HashMultiset keys = HashMultiset.create();
        for (int i = 0; i < tree.getArguments().size(); i += 2) {
            Object constantKey = this.getConstantKey(tree.getArguments().get(i + index), state);
            if (constantKey == null) continue;
            keys.add(constantKey);
        }
        return this.checkForRepeatedKeys(tree, (Multiset<Object>)keys);
    }

    private @Nullable Object getConstantKey(ExpressionTree key, VisitorState state) {
        return this.constantExpressions.constantExpression(key, state).orElse(null);
    }

    private Description checkForRepeatedKeys(MethodInvocationTree tree, Multiset<Object> keys) {
        ImmutableSet repeatedKeys = (ImmutableSet)keys.entrySet().stream().filter(e -> e.getCount() > 1).collect(ImmutableSet.toImmutableSet());
        if (repeatedKeys.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("This ImmutableMap construction will throw (or have known duplicates overwritten) due to duplicates: " + String.valueOf(repeatedKeys.stream().map(k -> k instanceof Symbol.VarSymbol ? ((Symbol.VarSymbol)k).getSimpleName() : k.toString()).collect(ImmutableSet.toImmutableSet()))).build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Api {
        PARSE_TIME((Matcher)MethodMatchers.staticMethod().onClassAny((Iterable)VALIDATORS.keySet()).named("parse").withParameters("java.lang.CharSequence", new String[0])){

            @Override
            void validate(MethodInvocationTree tree, String argument) {
                Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
                ((Consumer)VALIDATORS.get((Object)sym.owner.getQualifiedName().toString())).accept(argument);
            }
        }
        ,
        BYTE_STRING((Matcher)MethodMatchers.staticMethod().onClass("com.google.protobuf.ByteString").named("fromHex").withParameters("java.lang.String", new String[0])){

            @Override
            void validate(MethodInvocationTree tree, String argument) {
                try {
                    ByteString.class.getMethod("fromHex", String.class).invoke(null, argument);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    return;
                }
                catch (InvocationTargetException e) {
                    throw (NumberFormatException)Throwables.getCauseAs((Throwable)e.getCause(), NumberFormatException.class);
                }
            }
        }
        ,
        UUID_PARSE((Matcher)MethodMatchers.staticMethod().onClass("java.util.UUID").named("fromString")){

            @Override
            void validate(MethodInvocationTree tree, String argument) {
                UUID unused = UUID.fromString(argument);
            }
        };

        private final Matcher<ExpressionTree> matcher;

        private Api(Matcher<ExpressionTree> matcher) {
            this.matcher = matcher;
        }

        abstract void validate(MethodInvocationTree var1, String var2) throws Exception;
    }
}

