/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker.trial;

import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.VmOptionLogMessage;
import com.google.caliper.bridge.VmPropertiesLogMessage;
import com.google.caliper.model.VmSpec;
import com.google.caliper.runner.target.Target;
import com.google.caliper.runner.worker.WorkerScoped;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.inject.Inject;

@WorkerScoped
final class VmDataCollectingVisitor
extends AbstractLogMessageVisitor {
    private final ImmutableMap.Builder<String, String> vmOptionsBuilder = ImmutableMap.builder();
    private final Target target;
    private Optional<ImmutableMap<String, String>> vmProperties = Optional.absent();

    @Inject
    VmDataCollectingVisitor(Target target) {
        this.target = target;
    }

    VmSpec vmSpec() {
        ImmutableMap options = this.vmOptionsBuilder.build();
        return new VmSpec.Builder().addAllProperties((Map)this.vmProperties.get()).addAllOptions((Map)options).build();
    }

    public void visit(VmOptionLogMessage logMessage) {
        this.vmOptionsBuilder.put((Object)logMessage.name(), (Object)logMessage.value());
    }

    public void visit(VmPropertiesLogMessage logMessage) {
        this.vmProperties = Optional.of((Object)ImmutableMap.copyOf((Map)Maps.filterKeys((Map)logMessage.properties(), this.target.vm().vmPropertiesToRetain())));
    }
}

