/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.resultprocessor;

import com.google.caliper.model.Trial;
import com.google.caliper.runner.resultprocessor.ResultsUploader;
import com.google.common.base.Optional;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;

final class OkHttpUploadHandler
implements ResultsUploader.UploadHandler {
    private final OkHttpClient client;

    OkHttpUploadHandler(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public boolean upload(URI uri, String content, String mediaType, Optional<UUID> apiKey, Trial trial) {
        HttpUrl url = HttpUrl.get((URI)uri);
        if (apiKey.isPresent()) {
            url = url.newBuilder().addQueryParameter("key", ((UUID)apiKey.get()).toString()).build();
        }
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)mediaType), (String)content);
        Request request = new Request.Builder().url(url).post(body).build();
        try {
            Response response = this.client.newCall(request).execute();
            if (response.isSuccessful()) {
                return true;
            }
            int n = response.code();
            ResultsUploader.logger.fine(new StringBuilder(35).append("Failed upload response: ").append(n).toString());
        }
        catch (IOException e) {
            ResultsUploader.logUploadFailure(trial, e);
        }
        return false;
    }
}

