/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.DerivedGenerator;
import com.google.common.collect.testing.ElementTypesAreNonnullByDefault;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestContainerGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestSortedSetGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class DerivedCollectionGenerators {
    static <K, V> TestSetGenerator<K> keySetGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
        TestContainerGenerator<Map<K, V>, Map.Entry<K, V>> generator = mapGenerator.getInnerGenerator();
        if (generator instanceof TestSortedMapGenerator && ((TestSortedMapGenerator)generator).create(new Object[0]).keySet() instanceof SortedSet) {
            return new MapSortedKeySetGenerator<K, V>(mapGenerator);
        }
        return new MapKeySetGenerator<K, V>(mapGenerator);
    }

    private DerivedCollectionGenerators() {
    }

    public static class SortedMapSubmapTestMapGenerator<K, V>
    extends ForwardingTestMapGenerator<K, V>
    implements TestSortedMapGenerator<K, V> {
        final Bound to;
        final Bound from;
        final K firstInclusive;
        final K lastInclusive;
        private final Comparator<Map.Entry<K, V>> entryComparator;

        public SortedMapSubmapTestMapGenerator(TestSortedMapGenerator<K, V> delegate, Bound to, Bound from) {
            super(delegate);
            this.to = to;
            this.from = from;
            Object emptyMap = delegate.create(new Object[0]);
            this.entryComparator = Helpers.entryComparator(emptyMap.comparator());
            SampleElements samples = delegate.samples();
            List<Map.Entry> samplesList = Arrays.asList((Map.Entry)samples.e0(), (Map.Entry)samples.e1(), (Map.Entry)samples.e2(), (Map.Entry)samples.e3(), (Map.Entry)samples.e4());
            Collections.sort(samplesList, this.entryComparator);
            this.firstInclusive = samplesList.get(0).getKey();
            this.lastInclusive = samplesList.get(samplesList.size() - 1).getKey();
        }

        @Override
        public SortedMap<K, V> create(Object ... entries) {
            ArrayList<Map.Entry<K, V>> extremeValues = new ArrayList<Map.Entry<K, V>>();
            K firstExclusive = this.getInnerGenerator().belowSamplesGreater().getKey();
            K lastExclusive = this.getInnerGenerator().aboveSamplesLesser().getKey();
            if (this.from != Bound.NO_BOUND) {
                extremeValues.add(this.getInnerGenerator().belowSamplesLesser());
                extremeValues.add(this.getInnerGenerator().belowSamplesGreater());
            }
            if (this.to != Bound.NO_BOUND) {
                extremeValues.add(this.getInnerGenerator().aboveSamplesLesser());
                extremeValues.add(this.getInnerGenerator().aboveSamplesGreater());
            }
            ArrayList<Map.Entry> allEntries = new ArrayList<Map.Entry>();
            allEntries.addAll(extremeValues);
            for (Object entry : entries) {
                allEntries.add((Map.Entry)entry);
            }
            SortedMap map = (SortedMap)this.delegate.create(allEntries.toArray());
            return this.createSubMap(map, firstExclusive, lastExclusive);
        }

        SortedMap<K, V> createSubMap(SortedMap<K, V> map, K firstExclusive, K lastExclusive) {
            if (this.from == Bound.NO_BOUND && this.to == Bound.EXCLUSIVE) {
                return map.headMap(lastExclusive);
            }
            if (this.from == Bound.INCLUSIVE && this.to == Bound.NO_BOUND) {
                return map.tailMap(this.firstInclusive);
            }
            if (this.from == Bound.INCLUSIVE && this.to == Bound.EXCLUSIVE) {
                return map.subMap(this.firstInclusive, lastExclusive);
            }
            throw new IllegalArgumentException();
        }

        public final Bound getTo() {
            return this.to;
        }

        public final Bound getFrom() {
            return this.from;
        }

        public final TestSortedMapGenerator<K, V> getInnerGenerator() {
            return (TestSortedMapGenerator)this.delegate;
        }

        @Override
        public Map.Entry<K, V> belowSamplesLesser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> belowSamplesGreater() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> aboveSamplesLesser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> aboveSamplesGreater() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SortedSetSubsetTestSetGenerator<E>
    implements TestSortedSetGenerator<E> {
        final Bound to;
        final Bound from;
        final E firstInclusive;
        final E lastInclusive;
        private final Comparator<? super E> comparator;
        private final TestSortedSetGenerator<E> delegate;

        public SortedSetSubsetTestSetGenerator(TestSortedSetGenerator<E> delegate, Bound to, Bound from) {
            this.to = to;
            this.from = from;
            this.delegate = delegate;
            Set emptySet = delegate.create(new Object[0]);
            this.comparator = emptySet.comparator();
            SampleElements samples = delegate.samples();
            ArrayList samplesList = new ArrayList(samples.asList());
            Collections.sort(samplesList, this.comparator);
            this.firstInclusive = samplesList.get(0);
            this.lastInclusive = samplesList.get(samplesList.size() - 1);
        }

        public final TestSortedSetGenerator<E> getInnerGenerator() {
            return this.delegate;
        }

        public final Bound getTo() {
            return this.to;
        }

        public final Bound getFrom() {
            return this.from;
        }

        @Override
        public SampleElements<E> samples() {
            return this.delegate.samples();
        }

        @Override
        public E[] createArray(int length) {
            return this.delegate.createArray(length);
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.delegate.order(insertionOrder);
        }

        @Override
        public SortedSet<E> create(Object ... elements) {
            List<Object> normalValues = Arrays.asList(elements);
            ArrayList<E> extremeValues = new ArrayList<E>();
            for (Object o : elements) {
                if (o != null) continue;
                throw new NullPointerException();
            }
            E firstExclusive = this.delegate.belowSamplesGreater();
            E lastExclusive = this.delegate.aboveSamplesLesser();
            if (this.from != Bound.NO_BOUND) {
                extremeValues.add(this.delegate.belowSamplesLesser());
                extremeValues.add(this.delegate.belowSamplesGreater());
            }
            if (this.to != Bound.NO_BOUND) {
                extremeValues.add(this.delegate.aboveSamplesLesser());
                extremeValues.add(this.delegate.aboveSamplesGreater());
            }
            ArrayList<@Nullable Object> allEntries = new ArrayList<Object>();
            allEntries.addAll(extremeValues);
            allEntries.addAll(normalValues);
            Set set = this.delegate.create(allEntries.toArray());
            return this.createSubSet((SortedSet<E>)set, firstExclusive, lastExclusive);
        }

        SortedSet<E> createSubSet(SortedSet<E> set, E firstExclusive, E lastExclusive) {
            if (this.from == Bound.NO_BOUND && this.to == Bound.EXCLUSIVE) {
                return set.headSet(lastExclusive);
            }
            if (this.from == Bound.INCLUSIVE && this.to == Bound.NO_BOUND) {
                return set.tailSet(this.firstInclusive);
            }
            if (this.from == Bound.INCLUSIVE && this.to == Bound.EXCLUSIVE) {
                return set.subSet(this.firstInclusive, lastExclusive);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public E belowSamplesLesser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E belowSamplesGreater() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E aboveSamplesLesser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E aboveSamplesGreater() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Bound {
        INCLUSIVE,
        EXCLUSIVE,
        NO_BOUND;

    }

    static class ForwardingTestMapGenerator<K, V>
    implements TestMapGenerator<K, V> {
        TestMapGenerator<K, V> delegate;

        ForwardingTestMapGenerator(TestMapGenerator<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.delegate.order(insertionOrder);
        }

        @Override
        public K[] createKeyArray(int length) {
            return this.delegate.createKeyArray(length);
        }

        @Override
        public V[] createValueArray(int length) {
            return this.delegate.createValueArray(length);
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.delegate.samples();
        }

        @Override
        public Map<K, V> create(Object ... elements) {
            return (Map)this.delegate.create(elements);
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.delegate.createArray(length);
        }
    }

    public static class MapValueCollectionGenerator<K, V>
    implements TestCollectionGenerator<V>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;
        private final SampleElements<V> samples;

        public MapValueCollectionGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
            SampleElements mapSamples = this.mapGenerator.samples();
            this.samples = new SampleElements(((Map.Entry)mapSamples.e0()).getValue(), ((Map.Entry)mapSamples.e1()).getValue(), ((Map.Entry)mapSamples.e2()).getValue(), ((Map.Entry)mapSamples.e3()).getValue(), ((Map.Entry)mapSamples.e4()).getValue());
        }

        @Override
        public SampleElements<V> samples() {
            return this.samples;
        }

        @Override
        public Collection<V> create(Object ... elements) {
            Object[] valuesArray = elements;
            Collection<Map.Entry<K, V>> originalEntries = this.mapGenerator.getSampleElements(elements.length);
            ArrayList<Map.Entry<K, Object>> entries = new ArrayList<Map.Entry<K, Object>>(elements.length);
            int i = 0;
            for (Map.Entry<K, V> entry : originalEntries) {
                entries.add(Helpers.mapEntry(entry.getKey(), valuesArray[i++]));
            }
            return ((Map)this.mapGenerator.create(entries.toArray())).values();
        }

        @Override
        public V[] createArray(int length) {
            V[] vs = ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createValueArray(length);
            return vs;
        }

        @Override
        public Iterable<V> order(List<V> insertionOrder) {
            final List<Map.Entry<K, V>> orderedEntries = Helpers.castOrCopyToList(this.mapGenerator.order(Helpers.castOrCopyToList(this.mapGenerator.getSampleElements(5))));
            Collections.sort(insertionOrder, new Comparator<V>(){

                @Override
                public int compare(V left, V right) {
                    return this.indexOfEntryWithValue(left) - this.indexOfEntryWithValue(right);
                }

                int indexOfEntryWithValue(V value) {
                    for (int i = 0; i < orderedEntries.size(); ++i) {
                        if (!Helpers.equal(((Map.Entry)orderedEntries.get(i)).getValue(), value)) continue;
                        return i;
                    }
                    throw new IllegalArgumentException("Map.values generator can order only sample values");
                }
            });
            return insertionOrder;
        }

        public OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> getInnerGenerator() {
            return this.mapGenerator;
        }
    }

    public static class MapSortedKeySetGenerator<K, V>
    extends MapKeySetGenerator<K, V>
    implements TestSortedSetGenerator<K>,
    DerivedGenerator {
        private final TestSortedMapGenerator<K, V> delegate;

        public MapSortedKeySetGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            super(mapGenerator);
            this.delegate = (TestSortedMapGenerator)mapGenerator.getInnerGenerator();
        }

        @Override
        public SortedSet<K> create(Object ... elements) {
            return (SortedSet)super.create(elements);
        }

        @Override
        public K belowSamplesLesser() {
            return this.delegate.belowSamplesLesser().getKey();
        }

        @Override
        public K belowSamplesGreater() {
            return this.delegate.belowSamplesGreater().getKey();
        }

        @Override
        public K aboveSamplesLesser() {
            return this.delegate.aboveSamplesLesser().getKey();
        }

        @Override
        public K aboveSamplesGreater() {
            return this.delegate.aboveSamplesGreater().getKey();
        }
    }

    public static class MapKeySetGenerator<K, V>
    implements TestSetGenerator<K>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;
        private final SampleElements<K> samples;

        public MapKeySetGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
            SampleElements mapSamples = this.mapGenerator.samples();
            this.samples = new SampleElements(((Map.Entry)mapSamples.e0()).getKey(), ((Map.Entry)mapSamples.e1()).getKey(), ((Map.Entry)mapSamples.e2()).getKey(), ((Map.Entry)mapSamples.e3()).getKey(), ((Map.Entry)mapSamples.e4()).getKey());
        }

        @Override
        public SampleElements<K> samples() {
            return this.samples;
        }

        @Override
        public Set<K> create(Object ... elements) {
            Object[] keysArray = elements;
            Collection<Map.Entry<K, V>> originalEntries = this.mapGenerator.getSampleElements(elements.length);
            ArrayList<Map.Entry<Object, V>> entries = new ArrayList<Map.Entry<Object, V>>(elements.length);
            int i = 0;
            for (Map.Entry<K, V> entry : originalEntries) {
                entries.add(Helpers.mapEntry(keysArray[i++], entry.getValue()));
            }
            return ((Map)this.mapGenerator.create(entries.toArray())).keySet();
        }

        @Override
        public K[] createArray(int length) {
            return ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createKeyArray(length);
        }

        @Override
        public Iterable<K> order(List<K> insertionOrder) {
            Object v = ((Map.Entry)((TestMapGenerator)this.mapGenerator.getInnerGenerator()).samples().e0()).getValue();
            ArrayList entries = new ArrayList();
            for (K element : insertionOrder) {
                entries.add(Helpers.mapEntry(element, v));
            }
            ArrayList keys = new ArrayList();
            for (Map.Entry entry : this.mapGenerator.order(entries)) {
                keys.add(entry.getKey());
            }
            return keys;
        }

        public OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> getInnerGenerator() {
            return this.mapGenerator;
        }
    }

    public static class MapEntrySetGenerator<K, V>
    implements TestSetGenerator<Map.Entry<K, V>>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;

        public MapEntrySetGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.mapGenerator.samples();
        }

        @Override
        public Set<Map.Entry<K, V>> create(Object ... elements) {
            return ((Map)this.mapGenerator.create(elements)).entrySet();
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.mapGenerator.createArray(length);
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.mapGenerator.order(insertionOrder);
        }

        public OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> getInnerGenerator() {
            return this.mapGenerator;
        }
    }
}

