/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class CSSProperties {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface AnimationIterationCountUnionType {
    @JsOverlay
    static CSSProperties.AnimationIterationCountUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface AnimationUnionType {
    @JsOverlay
    static CSSProperties.AnimationUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderBottomLeftRadiusUnionType {
    @JsOverlay
    static CSSProperties.BorderBottomLeftRadiusUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderBottomRightRadiusUnionType {
    @JsOverlay
    static CSSProperties.BorderBottomRightRadiusUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderBottomWidthUnionType {
    @JsOverlay
    static CSSProperties.BorderBottomWidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderImageOutsetUnionType {
    @JsOverlay
    static CSSProperties.BorderImageOutsetUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderImageSliceUnionType {
    @JsOverlay
    static CSSProperties.BorderImageSliceUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderImageWidthUnionType {
    @JsOverlay
    static CSSProperties.BorderImageWidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderLeftWidthUnionType {
    @JsOverlay
    static CSSProperties.BorderLeftWidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderRadiusUnionType {
    @JsOverlay
    static CSSProperties.BorderRadiusUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderRightWidthUnionType {
    @JsOverlay
    static CSSProperties.BorderRightWidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderTopLeftRadiusUnionType {
    @JsOverlay
    static CSSProperties.BorderTopLeftRadiusUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderTopRightRadiusUnionType {
    @JsOverlay
    static CSSProperties.BorderTopRightRadiusUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderTopWidthUnionType {
    @JsOverlay
    static CSSProperties.BorderTopWidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface BorderWidthUnionType {
    @JsOverlay
    static CSSProperties.BorderWidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface FontSizeUnionType {
    @JsOverlay
    static CSSProperties.FontSizeUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface HeightUnionType {
    @JsOverlay
    static CSSProperties.HeightUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface LineHeightUnionType {
    @JsOverlay
    static CSSProperties.LineHeightUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MarginBottomUnionType {
    @JsOverlay
    static CSSProperties.MarginBottomUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MarginLeftUnionType {
    @JsOverlay
    static CSSProperties.MarginLeftUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MarginRightUnionType {
    @JsOverlay
    static CSSProperties.MarginRightUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MarginTopUnionType {
    @JsOverlay
    static CSSProperties.MarginTopUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MarginUnionType {
    @JsOverlay
    static CSSProperties.MarginUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MaxHeightUnionType {
    @JsOverlay
    static CSSProperties.MaxHeightUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MaxWidthUnionType {
    @JsOverlay
    static CSSProperties.MaxWidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MinHeightUnionType {
    @JsOverlay
    static CSSProperties.MinHeightUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface MinWidthUnionType {
    @JsOverlay
    static CSSProperties.MinWidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface OpacityUnionType {
    @JsOverlay
    static CSSProperties.OpacityUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface OutlineWidthUnionType {
    @JsOverlay
    static CSSProperties.OutlineWidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface PaddingBottomUnionType {
    @JsOverlay
    static CSSProperties.PaddingBottomUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface PaddingLeftUnionType {
    @JsOverlay
    static CSSProperties.PaddingLeftUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface PaddingRightUnionType {
    @JsOverlay
    static CSSProperties.PaddingRightUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface PaddingTopUnionType {
    @JsOverlay
    static CSSProperties.PaddingTopUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface PaddingUnionType {
    @JsOverlay
    static CSSProperties.PaddingUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface PerspectiveOriginUnionType {
    @JsOverlay
    static CSSProperties.PerspectiveOriginUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface TransformOriginUnionType {
    @JsOverlay
    static CSSProperties.TransformOriginUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface WidthUnionType {
    @JsOverlay
    static CSSProperties.WidthUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ZIndexUnionType {
    @JsOverlay
    static CSSProperties.ZIndexUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public String alignContent;
  public String alignItems;
  public String alignSelf;
  public CSSProperties.AnimationUnionType animation;
  public String animationDelay;
  public String animationDirection;
  public String animationDuration;
  public String animationFillMode;
  public CSSProperties.AnimationIterationCountUnionType animationIterationCount;
  public String animationName;
  public String animationPlayState;
  public String animationTimingFunction;
  public String azimuth;
  public String backfaceVisibility;
  public String background;
  public String backgroundAttachment;
  public String backgroundColor;
  public String backgroundImage;
  public String backgroundPosition;
  public String backgroundRepeat;
  public String backgroundSize;
  public String border;
  public String borderBottom;
  public String borderBottomColor;
  public CSSProperties.BorderBottomLeftRadiusUnionType borderBottomLeftRadius;
  public CSSProperties.BorderBottomRightRadiusUnionType borderBottomRightRadius;
  public String borderBottomStyle;
  public CSSProperties.BorderBottomWidthUnionType borderBottomWidth;
  public String borderCollapse;
  public String borderColor;
  public String borderImage;
  public CSSProperties.BorderImageOutsetUnionType borderImageOutset;
  public String borderImageRepeat;
  public CSSProperties.BorderImageSliceUnionType borderImageSlice;
  public String borderImageSource;
  public CSSProperties.BorderImageWidthUnionType borderImageWidth;
  public String borderLeft;
  public String borderLeftColor;
  public String borderLeftStyle;
  public CSSProperties.BorderLeftWidthUnionType borderLeftWidth;
  public CSSProperties.BorderRadiusUnionType borderRadius;
  public String borderRight;
  public String borderRightColor;
  public String borderRightStyle;
  public CSSProperties.BorderRightWidthUnionType borderRightWidth;
  public String borderSpacing;
  public String borderStyle;
  public String borderTop;
  public String borderTopColor;
  public CSSProperties.BorderTopLeftRadiusUnionType borderTopLeftRadius;
  public CSSProperties.BorderTopRightRadiusUnionType borderTopRightRadius;
  public String borderTopStyle;
  public CSSProperties.BorderTopWidthUnionType borderTopWidth;
  public CSSProperties.BorderWidthUnionType borderWidth;
  public String bottom;
  public String boxShadow;
  public String boxSizing;
  public String captionSide;
  public String clear;
  public String clip;
  public String color;
  public String contain;
  public String content;
  public String counterIncrement;
  public String counterReset;
  public String cssFloat;
  public String cssText;
  public String cue;
  public String cueAfter;
  public String cueBefore;
  public String cursor;
  public String direction;
  public String display;
  public String elevation;
  public String emptyCells;
  public String flex;
  public String flexBasis;
  public String flexDirection;
  public String flexFlow;
  public double flexGrow;
  public double flexShrink;
  public String flexWrap;
  public String font;
  public String fontFamily;
  public CSSProperties.FontSizeUnionType fontSize;
  public String fontSizeAdjust;
  public String fontStretch;
  public String fontStyle;
  public String fontVariant;
  public String fontWeight;
  public CSSProperties.HeightUnionType height;
  public String justifyContent;
  public String left;
  public String letterSpacing;
  public CSSProperties.LineHeightUnionType lineHeight;
  public String listStyle;
  public String listStyleImage;
  public String listStylePosition;
  public String listStyleType;
  public CSSProperties.MarginUnionType margin;
  public CSSProperties.MarginBottomUnionType marginBottom;
  public CSSProperties.MarginLeftUnionType marginLeft;
  public CSSProperties.MarginRightUnionType marginRight;
  public CSSProperties.MarginTopUnionType marginTop;
  public String markerOffset;
  public String marks;
  public CSSProperties.MaxHeightUnionType maxHeight;
  public CSSProperties.MaxWidthUnionType maxWidth;
  public CSSProperties.MinHeightUnionType minHeight;
  public CSSProperties.MinWidthUnionType minWidth;
  public String objectFit;
  public String objectPosition;
  public CSSProperties.OpacityUnionType opacity;
  public double order;
  public String orphans;
  public String outline;
  public String outlineColor;
  public String outlineStyle;
  public CSSProperties.OutlineWidthUnionType outlineWidth;
  public String overflow;
  public CSSProperties.PaddingUnionType padding;
  public CSSProperties.PaddingBottomUnionType paddingBottom;
  public CSSProperties.PaddingLeftUnionType paddingLeft;
  public CSSProperties.PaddingRightUnionType paddingRight;
  public CSSProperties.PaddingTopUnionType paddingTop;
  public String page;
  public String pageBreakAfter;
  public String pageBreakBefore;
  public String pageBreakInside;
  public String pause;
  public String pauseAfter;
  public String pauseBefore;
  public String perspective;
  public CSSProperties.PerspectiveOriginUnionType perspectiveOrigin;
  public String pitch;
  public String pitchRange;
  public String playDuring;
  public String pointerEvents;
  public String position;
  public String quotes;
  public String resize;
  public String richness;
  public String right;
  public String size;
  public String speak;
  public String speakHeader;
  public String speakNumeral;
  public String speakPunctuation;
  public String speechRate;
  public String stress;
  public String tableLayout;
  public String textAlign;
  public String textDecoration;
  public String textIndent;
  public String textOverflow;
  public String textShadow;
  public String textTransform;
  public String top;
  public String transform;
  public CSSProperties.TransformOriginUnionType transformOrigin;
  public String transformStyle;
  public String transition;
  public String transitionDelay;
  public String transitionDuration;
  public String transitionProperty;
  public String transitionTimingFunction;
  public String unicodeBidi;
  public String userSelect;
  public String verticalAlign;
  public String visibility;
  public String voiceFamily;
  public String volume;
  public String whiteSpace;
  public String widows;
  public CSSProperties.WidthUnionType width;
  public String willChange;
  public String wordSpacing;
  public String wordWrap;
  public CSSProperties.ZIndexUnionType zIndex;
}
