## RStudio 2024.12.0 "Kousa Dogwood" Release Notes

### New
#### RStudio
- RStudio now supports the inclusion of environment variables when publishing applications to Posit Connect. (#13032)
- Available environment variables are now provided as completion suggestions within `Sys.unsetenv()`. (#15215)
- RStudio now supports new features from the R graphics engine (groups, glyphs) when supported by the underlying device. (#14613)
- The `.Rproj.user` folder location can now be customized globally by both users and administrators. (#15098)
- RStudio now supports code formatting using the 'styler' R package, as well as other external applications. (#2563)
- The RStudio diagnostics system now supports destructuring assignments as implemented in the `dotty` package.
- The "Include all function arguments in the completion list" user preference can be used to control whether RStudio includes function arguments that appear to have already been used in the current context. (#13065)
- RStudio supports `usethis.description` option values when creating projects via the RStudio New Project wizard. (#15070)
- Rename in Scope now operates across chunks within R Markdown and Quarto documents. (#4961)
- RStudio now respects the chunk 'dpi' option when generating plots in R Markdown and Quarto documents. (#11649)
- RStudio now supports the display of an HTML table of contents for R help files when `options(help.htmltoc = TRUE)` is set. (#14523)
- RStudio now includes `.env` files in the fuzzy finder and displays these files in the Files pane.
- Quarto documents now have a gear icon for editing cell (chunk) options. (#11745)
- A "Copy RStudio Version" command has been added to the command palette for copying the RStudio version, commit, and build date to the clipboard.
- RStudio now supports syntax highlighting for Fortran source files. (#10403)
- The label "Publish" now appears next to the publish icon on the editor toolbar. (#13604)
- The font size used for the document outline can now be customized [Accessibility]. (#6887)
- The `www-socket` option has been added to rserver.conf to enable the server to listen on a Unix domain socket (#14938; Open-Source Server).
- The "Insert Chunk" button now acts as a menu in both Quarto and R Markdown documents. (#14785)
- Improved support for highlighting nested chunks in R Markdown and Quarto documents. (#10079)
- Improved support for variable-width chunk headers and footers in R Markdown and Quarto documents. (#15191)
- RStudio now provides executed chunk code as a single multi-line entry in the Console history. (#3520)
- RStudio now provides snippet completions within function calls and subset calls. (#13441)
- RStudio now supports zooming the IDE via Meta + NumpadAdd and Meta + NumpadSubtract. (#12242)
- RStudio now uses `lobstr::obj_size()` when computing object sizes for display in the Environment pane. (#15369)
- The RStudio IDE User Guide and the RStudio & Posit Workbench Release Notes have versioned URLs in the Guides drop-down menu in the navigation bar. Additionally, the navigation bar links to the Release Notes and Versions URLs have versioned URLs. (#15223)


#### Posit Workbench
- Added preview support for Positron Pro sessions on RHEL9 and Ubuntu 22/24. Positron Pro sessions must be manually configured by an admin. (rstudio-pro#6861)
- Added support for saving Positron Pro state across user logout. (rstudio-pro#6820)
- Added a feature that prevents Positron Pro and VS Code sessions from starting for insecure (non-SSL/TLS) contexts because they require SSL/TLS for full functionality. (rstudio-pro#3741)
- Added a `session-timeout-kill-hours` setting to VS Code and Positron Pro sessions, which terminates sessions after being idle for a set number of hours. There is a known issue that prevents this feature from working correctly with a custom www-root-path. (rstudio-pro#5746)
- Added the Quarto, Posit Shiny, and Posit Publisher extensions to the default `vscode.extensions.conf` file for fresh installs. These extensions will be installed automatically for users upon VS Code session launch. (rstudio-pro#6388)
- Added preview support for setting an active timeout, which logs out users after a period of time, regardless of activity. (rstudio-pro#5815)
- Added a new session init container that copies session components to the session container, allowing updates to components independent of the session image. The session init container can be enabled in Kubernetes sessions by setting `launcher-sessions-auto-update=1` in `rserver.conf`. Additionally, the init container uses a new multi-platform Linux session components package to support session images across different Linux distributions. (rstudio-pro#6821)
- Added the `auth-user-rewrite-rule` setting to `rserver.conf`. When this option is set in environments with Google OAuth, OpenID, SAML, or Proxied Authentication configured, Workbench will rewrite the username from the authentication provider using the provided regex. (rstudio-pro#2502)
- Added support for HTTP Proxy variables in rserver and rsession to enable managed credentials features in Workbench environments behind a proxy server. (rstudio-pro#5893)
- Set Posit Public Package Manager (P3M) as the default for R libraries in RStudio Pro sessions, if no other repository is specified. Package Manager will deliver pre-built binary packages when available, which are faster to install than source packages and don't require most additional build dependencies. (rstudio-pro#5066)
- Added support to the Workbench API for registering shell scripts as session hooks that can run when a session starts and stops. (rstudio-pro#6428)
- Extended the Workbench API, adding support for launching jobs, resuming sessions, and retrieving user lists. Additionally, support for passing in environment variables, session hooks, and a file to open on session load has been added to the launch session endpoint. (rstudio-pro#5066)
- The Posit Workbench Administration Guide, the Posit Workbench User Guide, and the Posit Workbench Licenses Guide have versioned URLs in the Guides drop-down menu in the navigation bar. (rstudio-pro#6151)
- The Posit Workbench User Guide underwent a reorganization of how the individual IDE guides are presented. Each guide was migrated from the left-hand navigation to the upper (main) navigation bar. Now, when a guide is selected from the navigation bar, only that guide's contents display in the left-hand navigation. Additionally, the Posit Workbench guide was renamed to "Workbench Setup" in the navigation bar to prevent confusion between the title of the guide and to create more distinction between the home page of the guide and the Posit Workbench Overview. Lastly, the links for the five IDEs were updated to navigate to the corresponding guide within the Posit Workbench User Guide (instead of the IDE's external site) and are displayed as buttons. (rstudio-pro#6069)
- Added an FAQ page to the Reference Architectures section of the Posit Workbench Administration Guide. (rstudio-pro#6645)
- Re-designed the user experience for configuring managed credentials (rstudio-pro#6748)
- Added support for using Azure delegated credentials to access DevOps repositories (rstudio-pro#6734)
- Improved the database migration experience with additional feedback to the admin, logging, and potential error handling (rstudio-pro#6674)
- Improved diagnostics for the license manager (rstudio-pro#5932)
- Added support for reloading the Launcher through systemd (rstudio-pro#3749)
- Added support for a configurable auth (SAML/OpenID) username re-write rule (rstudio-pro#6987)
- Migrated Snowflake Native App documentation from Posit Workbench Administration Guide to the [Posit Partnerships](https://docs.posit.co/partnerships/snowflake/) site. <i class="bi bi-info-circle-fill" title="Documentation change since last release/patch."></i>

### Fixed
#### RStudio
- "Run All" now only executes R chunks when "Chunk Output in Console" is set. (#11995)
- Fixed an issue where the chunk options popup didn't recognize chunk labels preceded by a comma. (#15156)
- Fixed an issue where the chunk options popup was confused by quoted strings containing spaces. (#6829)
- Fixed an issue where the chunk options popup was confused by spaces around equals signs. (#2673)
- Fixed the chunk options popup to work in Visual Mode for non-R chunks. (#15312)
- Fixed issue where collapsed raw chunks were displayed with an incorrect label in the Visual Editor. (#14594)
- Fixed an issue where an R Markdown chunk label containing dashes was truncated in Visual Editor. (#15162)
- Fixed issue with highlight of `tikz` code chunks in R Markdown documents. (#15019)
- Fixed an issue where ghost text could not be inserted in non-chunk parts of an R Markdown / Quarto document. (#14507)
- Fixed an issue where the R session could crash on connect while generating console output. (#15330)
- Fixed an issue where some output from `uv` could be rendered blurry in the RStudio Console. (#15282)
- Fixed an issue where right-clicking on the console history did not present Paste as an option. (#14538)
- RStudio no longer logs warning / error messages related to disabled R actions (e.g., ReadConsole) in forked sessions. (#15221)
- Fixed an issue where the Console header label was not properly layed out when other tabs (e.g., Terminal) were closed. (#15106)
- Fixed Windows Desktop Pro so it starts up after using the Choose R dialog. (rstudio-pro#6062)
- Fixed an issue with the splash screen appearing on top of the Desktop Pro Manage License. (rstudio-pro#6962)
- Fixed Mac Desktop Pro so it starts on an ARM (Mx) Mac that doesn't have Rosetta2 installed. (rstudio-pro#3558)
- RStudio Desktop now forwards `LD_LIBRARY_PATH` when detecting available R installations. (#15044)
- Fixed an issue where attempts to publish to a collaborator’s application could fail to update that application. (#15065)
- Fixed an issue where the Rename File command did not write unsaved changes before performing the rename. (#15242)
- Fixed being unable to save file after cancelling the "Choose Encoding" window. (#14896)
- Fixed problems creating new files and projects on a UNC path. (#14963, #14964; Windows Desktop)
- Fixed an issue where RStudio could autosave files on blur even while a Save As... modal was active. (#15303)
- Fixed an issue where the IDE could hang when changing the file type of an R Markdown document. (#15313)
- Fixed an issue where autocompletion results within piped expressions were incorrect in some cases. (#13611)
- Fixed an issue where completion types for objects with a `.DollarNames` method were not properly displayed. (#15115)
- Fixed an issue where quoted variable names were not completed properly in dplyr pipes. (#15161)
- Fixed an issue with incorrect completions provided in `readline()` context. (#15238)
- Fixed issue where certain Python variable names were incorrectly quoted when inserted via autocompletion. (#14560)
- Fixed an issue where column names starting with numbers were not properly quoted when inserted as a completion. (#13290)
- Reformat Code no longer inserts whitespace around '^' operator. (#14973)
- Auto-saves no longer trim trailing whitespace on the line containing the cursor. (#14829)
- Fixed an issue where pressing Tab would insert a literal tab instead of indenting a multi-line selection. (#15046)
- Fixed an issue where debugger breakpoints did not function correctly in some cases with R 4.4. (#15072)
- RStudio over-aggressively required packages to be rebuilt when setting breakpoints. (#15201)
- Clicking in the editor gutter to toggle a breakpoint no longer also selects the associated line. (#15226)
- Fixed a performance regression that occurred when requesting completions for very large R objects. (#15422)
- RStudio now uses current session repositories when installing package dependencies via background jobs. (#10016)
- RStudio now forward the current 'repos' option for actions taken in the Build pane. (#5793)
- Executing `options(warn = ...)` in an R code chunk now persists beyond chunk execution. (#15030)
- Prevent attempting to start Copilot on a non-main thread. (#14952)
- Fixed an issue where updating the Copilot agent on Windows could fail if Copilot was already in use. (#14850)
- Prompt for personal access token instead of password when using GitHub via HTTPS. (#14103)
- RStudio now includes Markdown headers without any label in the document outline. (#14552)
- Remove focus-visible polyfill and instead use native browser :focus-visible pseudoclass [Accessibility]. (#14352)
- Fixed an issue where RStudio could hang on startup with projects containing a very large number of files. (#15434)

#### Posit Workbench
- Fixed an issue with Workbench login not respecting "Stay signed in when browser closes" when using Single Sign-On (SSO). (rstudio-pro#5392)
- Fixed Slurm queue (partition) selection behavior in the launcher UI (**Slurm resource profiles that specify an invalid queue are now disabled in the UI**). (rstudio-pro#7025)
- Fixed several cross-reference links in the Posit Workbench Administration Guide and Posit Workbench User Guide - VS Code sections. (rstudio-pro#6678)
- Fixed heading anchor ID issue in Posit Administration Guide - VS Code PWB Code Server section. (rstudio-pro#6961)
- Fixed inconsistencies in naming throughout Reference Architecture sections. (rstudio-pro#6832)
- Fixed an issue where Workbench does not properly set the queue when starting a session (rstudio-pro#7025)
- Fixed an issue where the displayed contianer image does not match the used image when starting a Kubernetes session (rstudio-pro#6910)
- Fixed an issue where a user mismatch would return a 500 instead of a 401 (rstudio-pro#6579)
- Fixed an issue where Workbench Jobs in VS Code show NaN when there is no maximum memory value configured (rstudio-pro#6510)
- Fixed an issue when resuming RStudio Pro sessions where the version of unattached R packages is not prsevered (rstudio-pro#3074)

### Upgrade Instructions

#### Posit Workbench
If running Workbench behind a proxy server, you may need to update your `NO_PROXY` configuration:

- HTTP Proxy variables are now supported in rserver and rsession, so it's important to include local addresses to Job Launcher sessions and other internal services in your `NO_PROXY` list.
- See the [Outgoing Proxies](https://docs.posit.co/ide/server-pro/access_and_security/outgoing_proxies.html) section of the Posit Workbench Administration Guide for more information. (rstudio-pro#5893)

You may also want to update the following configuration entries, as the default values have changed: 

   | Configuration entry | Previous default value | New default value | Reference |
   |-------------------- | ---------------------- | ------------------ | -----------|
   | `rsession-proxy-max-wait-secs` | 10 | 30| (rstudio-pro#6149) |
   | `www-thread-pool-size` | 2 | 6 | (rstudio-pro#6149) |

### Dependencies
- Updated GWT to version 2.10.1. (#15011)
- Updated Electron to version 31.7.6. (#14982; Desktop)

### Deprecated / Removed
- Removed user preference for turning off focus indicator rectangles. (#14352)
- Removed support for `rsconnect-jupyter`; publish Jupyter Notebooks to Connect using `rsconnect-python`. See the [Publishing Jupyter Notebooks to Connect](https://docs.posit.co/ide/server-pro/integration/jupyter-multiple-python-versions.html#publishing-jupyter-notebooks-to-connect) section of the Posit Workbench Administration Guide for more information. (rstudio-pro#6989)
