## RStudio 2024.09.0 "Cranberry Hibiscus" Release Notes

### New

- Posit Product Documentation theme v4.0.2; adds dark mode and several accessibility improvements (rstudio-pro#6373)
- Added ability for RStudio and Workbench to use AES 256 encryption (rstudio-pro#4011)

#### RStudio

- You can now toggle between R and Python in the Console by clicking on the language's logo in the Console pane header. (#11613)
- Allow customization of the project scratch path location. (#14875)
- Restart commands are now run after restoring the search path + global environment by default. (#14636)
- The "Save as Image" dialog now includes a checkbox "Use device pixel ratio", controlling whether plots are scaled according to the current display's DPI. (#14727)
- The "Soft-wrap R source files" preference now applies to all source files, and has been re-labelled appropriately. (#10940)
- RStudio now supports Electron flags set via `~/.config/rstudio/electron-flags.conf` or `~/.config/electron-flags.conf` on Linux / macOS. On Windows, the paths are `%LocalAppData%\RStudio\electron-flags.conf` and `%LocalAppData%\electron-flags.conf`. (#14641)
- RStudio now uses a glimpse-like display for data.frame list-column entries. (#14257)

#### Posit Workbench

- Quitting Jupyter and VS Code sessions from the home page no longer force quits them immediately; instead, they are given time to exit gracefully, as with RStudio Pro sessions (rstudio-pro#5317)
- Workbench jobs launched on Kubernetes or on Slurm with Singularity support will now default to using the same container image as the parent session (rstudio-pro#5875)
- Workbench's Prometheus metrics now track R and Python jobs launched, in addition to sessions (rstudio-pro#6271)
- When launching sessions on Slurm, environment variables set by the Slurm scheduler itself should now be available to sessions (rstudio-pro#5148, rstudio-pro#4692, rstudio-pro#3255)
- The `launcher-sessions-forward-container-environment` flag has been deprecated and will be removed in a future version. Use `launcher-sessions-forward-environment=0` to disable environment variable forwarding instead (rstudio-pro#5895)
- The New Project dialog in RStudio Pro now defaults to the R version of the current session, rather than the system default (rstudio-pro#4244)
- Workbench jobs launched from RStudio Pro now default to the R version of the current session, rather than the system default (rstudio-pro#5903)
- Added support for Jupyter Notebook 7 (rstudio-pro#6266)
- Replaced code server binary with PWB Code Server. PWB Code Server is bundled with the PWB VS Code Extension, so a separate install is no longer required. It is a fork of VS Code 1.93.0. (rstudio-pro#6265)
- In VS Code sessions, Workbench now preserves the open directory or workspace on a per-session basis. (rstudio-pro#6491)
- Fixed an issue preventing potential data leakage between users in the same browser session. As a result, the minimum recommended version of Firefox is now `126.0`. See the [Browser requirements](https://docs.posit.co/ide/server-pro/2024.08.0/getting_started/requirements.html#browser-requirements) section of the admin guide for more details (vscode-server#17)
- Disabled Jupyter Notebooks by default on fresh installs of PWB (rstudio-pro#6269)
- Workbench now respects the `SLURM_CONF` environment variable, which can be used to point to a non-standard location for the Slurm configuration file (launcher#767)
- Workbench now does a better job of tracking which Slurm jobs it owns, allowing multiple independent Workbench servers to use the same Slurm cluster, or a single Workbench server to use the same backing Slurm cluster with different configurations (launcher#908)
- Preview of the workbench api, using api-tokens for launching sessions and session status. See documentation for details.
- Added support for just-in-time provisioning of local user accounts for Proxied Auth, OpenID Connect, and SAML Authentication. Just-in-time provisioning creates users on first login, and can serve as an alternative to SCIM-based provisioning for Identity Providers that do not support the SCIM protocol (rstudio-pro#5909)
- Workbench now has a native integration for Snowflake that includes support for managed Snowflake OAuth credentials, allowing end users to sign into a Snowflake account from the home page and, using their existing identity, be immediately granted access to data and warehouses (rstudio-pro#6280)
- Added visual credential controls to the New Session dialog to quickly sign into and select credentials for new sessions (rstudio-pro#6287)
- Added an Edit Credentials dialog to allow users to select and sign into Workbench-supported cloud providers, with a few additional controls over the selection widget (rstudio-pro#6287)
- Updated Admin Guide with additional guidance for Kubernetes installations on [accessing license files from secrets](https://docs.posit.co/ide/server-pro/2024.09.0/getting_started/installation/kubernetes_installation.html#create-a-secret-containing-a-license-file) and [specifying PostgreSQL database passwords as environment variables](https://docs.posit.co/ide/server-pro/2024.09.0/getting_started/installation/kubernetes_installation.html#create-a-secret-containing-a-postgresql-database-password). (rstudio-pro#5312)
- Improved performance of Workbench when automatic user provisioning is enabled by adding support for the Workbench NSS library to communicate over unix socket (rstudio-pro#6591)

### Fixed

#### RStudio

- The RStudio diagnostics system no longer automatically loads packages when encountering calls of the form `dplyr::mutate()`. (#9692)
- Fixed an issue where breakpoints set within `observeEvent()` calls in Shiny applications did not behave correctly. (#14815)
- Fixed an issue where Build output from 'Run Tests' was not appropriately coloured. (#13088)
- Fixed an issue where various editor commands (Reindent Lines; Run Chunks) could fail in a document containing Quarto callout blocks. (#14640)
- Fixed an issue where end fold markers were not rendered correctly in Quarto documents. (#14699)
- Fixed an issue where the context menu sometimes did not display when right-clicking a word in the editor. (#14575)
- Fixed an issue where the "Go to directory..." button brought up the wrong dialog (#14501; Desktop)
- Fixed an issue where "View plot after saving" in the Save Plot as Image dialog sometimes did not work. (#14702)
- Fixed an issue where the IDE could hang when navigating the Files pane to a directory containing a very large number of files. (#13426)
- Fixed an issue where RStudio could trigger active bindings in environments when requesting completions. (#14784)
- Fixed an issue where the editor scroll speed had inadvertently been decreased. (#14664)
- Fixed an issue where external links couldn't be opened from a popped-out Help pane window. (#14801; Desktop)
- Fixed an issue where loaded package DLLs were not unloaded prior to attempting to build and install an under-development package from the Packages pane. (#13399)
- Fixed an issue where breakpoints could not be added to an already-sourced file in some cases. (#14682)
- Fixed an issue where autocompletion results did not display for datasets imported via `haven::read_sav()` in some scenarios. (#14672)
- Fixed an issue where paths were not tilde-aliased after selection in certain desktop dialogs. (#14851)
- Fixed an issue where the RStudio diagnostics system could emit spurious errors for documents using the R pipebind placeholder `_`. (#14713)
- Fixed an issue where RStudio incorrectly modified the PATH when "Automatically activate project-local Python environments" was checked. (#14659)
- Fixed an issue where column name completions could be very slow for SQL tables with dbplyr (>= 2.4.0). (#14864)
- Remove superfluous Uninstall shortcut and Start Menu folder (#1900; Desktop installer on Windows)
- Hide Refresh button while Replace All operation is running in the Find in Files pane (#13873)
- Stop the File Pane's "Copy To" operation from deleting the file when source and destination are the same (#14525)
- Fix keyboard shortcuts acting on the wrong source file when using Visual Editor in source columns or separate windows (#12581, #11684)
- Fix startup error due to invalid zoom setting triggering a config schema violation (#14690) 
- Removed extra spaces after package names in warning message about required packages (#14608)
- Moved the "Sign commit" checkbox to Git/Svn global options panel (##14559)
- RStudio's editor highlighting no longer accepts embedded spaces in '#|' comment prefixes. (#14592)
- RStudio now preserves a file's existing line endings when performing a Find and Replace. (#14796)
- Fixed an issue with loading and saving files to folders whose path partially patches the user's home folder (#14764)
- Fixed an issue where headers without a label in R Markdown documents were not shown in the scope tree. (#13159)
- Fixed an issue where RStudio could launch with an incorrect initial working directory when using multiple sessions. (#14695)
- Fixed an issue where ggplot2 aesthetic completions were not provided for plots assigned to a variable. (#14566)
- Fixed an issue where attempting to inspect a list-column entry in a View()-ed data.frame with custom row names would fail. (#14509)
- Fixed an issue where the document outline in Quarto documents could incorrectly render in very long documents in some scenarios. (#14906)
- Fixed an issue with a once-in-a-long-while auto-save error dialog. (rstudio-pro#6468)
- Fixed an issue with linux PAM session error handling. (#12116)
- Fixed an issue where the RStudio debugger location could be incorrect when debugging a package's S3 method. (#14499)
- Fixed an issue where RStudio could hang when clicking on a citation in the visual editor. (#10823)
- Fixed RStudio Desktop Pro crashing at startup on macOS 15 Sequoia. (rstudio-pro#6777)

#### Posit Workbench

- Workbench jobs now set resource profiles correctly (rstudio-pro#5217)
- When launching a Workbench job from RStudio Pro, changing fields in the Options tab no longer resets the selected R version in the Environment tab (rstudio-pro#5218)
- Fixed bug that prevented users from receiving the admin-configured default settings when launching VS Code sessions (rstudio-pro#6207)
- RStudio Pro sessions run inside Singularity containers on Slurm now respect the `modules-bin-path` setting (rstudio-pro#6319)
- When user provisioning is enabled, server logs no longer contain related debug messages unless debug logging is enabled (rstudio-pro#6480)
- Trailing slashes in Databricks workspace URLs in the `databricks.conf` file no longer prevent users from signing in to Databricks from the home page (rstudio-pro#6435)
- Resource profiles on Kubernetes and Slurm are now listed in the order in which they appear in the config file (rstudio-pro#6485)
- Switching the selected IDE when launching a session from the home page no longer resets the image selection (rstudio-pro#4079)
- Removed an error starting sessions in some docker containers about resetting keyrings, other unnecessary debug messages (rstudio-pro#6444)
- Fixed a bug where users who attempted login before being provisioned could not log in after being provisioned (rstudio-pro#6564)
- Fixed bug that prevented Workbench from respecting licenses with an unlimited named user limit when re-activating SCIM provisioned users (rstudio-pro#6561)
- Fixed bug where user provisioning would not work properly if the homedir column in the database for any user was null (rstudio-pro#6587)
- Fixed a pagination issue in the SCIM API that could prevent more than 100 users from being provisioned via Okta (rstudio-pro#6608)
- Fixed various bugs that could cause NSS requests to fail when automatic user provisioning is enabled (rstudio-pro#6676, rstudio-pro#6657)

### Upgrade Instructions

#### Posit Workbench

If upgrading from Workbench 2024.04.x with automatic user provisioning enabled, to fix a performance and reliability issue, the `server-address` setting in `workbench-nss.conf` should be updated to `unix:/var/run/rstudio-server/rstudio-rserver/user-service.socket`. See [User Provisioning Configuration](https://docs.posit.co/ide/server-pro/user_provisioning/configuration.html) in the Workbench Admin Guide for more information. (rstudio-pro#6591)

### Dependencies

- Updated MathJax to version 2.7.9 (#11535)
- Updated node.js to version 20.15.1 (#14826)
- Updated Electron to version 30.4.0 (#14582; Desktop)
- Updated Quarto to version 1.5.57 (#14884, #15102)
- Updated rserver-saml to version 0.8.0 (rstudio-pro#6529)
- Updated rserver-openid to version 0.7.0 (rstudio-pro#6635)
- Updated nginx to version 1.26.0 (rstudio-pro#6581)
