## RStudio 2024.04.0 "Chocolate Cosmos" Release Notes

### New

#### RStudio

- RStudio now requires R 3.6.0 or newer. (#14210)
- RStudio's auto-completion system now supports ggplot2 aesthetic names and data columns. (#8444)
- RStudio's auto-completion system now supports the display of the "label" attribute. (#14242)
- RStudio Desktop on Windows and Linux supports auto-hiding the menu bar. (#8932)
- RStudio Desktop on Windows and Linux supports full-screen mode via F11. (#3243)
- RStudio Desktop now supports pasting of file paths for files copied to the clipboard. (#14240)
- RStudio now reports a diagnostics warning when `=` (rather than `==`) is used in `if`, `for`, and `while` conditionals. (#14455)
- R projects can be given a custom display name in Project Options. (#1909)
- The automatic display of Copilot code completions can now be controlled via a user preference. (#14033)
- Copilot code suggestions can now be requested via the keyboard shortcut `Ctrl + \`.
- The next word in a Copilot code suggestion can now be accepted via `Ctrl + Right` (`Cmd + Right` on macOS). (#14395)
- RStudio now highlights and lints Quarto chunk options in Python code chunks.
- RStudio no longer highlights `\[ \]` and `\( \)` Mathjax equations; prefer `$$ $$` and `$ $` instead. (#12862)
- Added cmake option to build RStudio without the check for updates feature. (#13236)
- Allow choosing R from non-standard location at startup. (#14180; Windows Desktop)
- Add `EnvironmentFile` support to systemd service definitions. (#13819)
- RStudio's GWT sources can now be built with JDKs > 11. (#11242)
- Show grey background instead of solid-white during Desktop startup. (#13768)
- The 'restartSession()' API method gains the 'clean' argument. (#2841)
- 'dot' chunks in R Markdown documents are now executable. (#14063)
- (rstudioapi) Fixed an issue where selectFile() did not parse filter strings in a cross-platform way. (#13994)
- Show Quarto version information in the About dialog. (#14263)
- RStudio now reports repository validation errors (if any) when adding secondary repositories in the Global Options -> Packages pane. (#13842)
- The working directory of a background job now defaults to the .Rproj location when a project is open. (#12600)
- Add search results copy button and search results breadcrumbs to RStudio User Guide. (#13618, #14069)
- RStudio now supports generation of a Copilot diagnostic report from the Copilot preferences pane. (#14358)
- The RStudio debugger is now better at matching debugged code to source documents. (#13925)
- RStudio no longer includes spurious chunk markers from Copilot completion results. (#13686)
- Added new commands which toggle the maximized state of Console, Source, and Tab Group quadrants [Accessibility]. (#7022)
- RStudio now prints a warning if an overly-long line of console input is truncated when sending to R. (#14420)
- Implemented Posit Product Documentation theme to RStudio & Posit Workbench Release Notes and RStudio IDE User Guide via Quarto extension. (#14513)

#### Posit Workbench
- Show custom project names on Workbench homepage. (rstudio-pro#5589)
- Added support for JupyterLab 4 through the Python extension [PWB JupyterLab](https://pypi.org/project/pwb-jupyterlab/). (rstudio-pro#5777)
- Added search results copy button and search results breadcrumbs to Workbench Administration Guide, Workbench User Guide, RStudio Desktop Pro Administration Guide. (#5088, #5603)
- Migrated Troubleshooting Launcher and Kubernetes guide from docs.posit.co site to Workbench Administration Guide: Job Launcher > Launcher Troubleshooting section. (#5720)
- Added search results copy button and search results breadcrumbs to Workbench Administration Guide, Workbench User Guide, RStudio Desktop Pro Administration Guide. (#5088, #5603)
- When launching sessions from the home page, memory is now shown in GB rather than MB. (rstudio-pro#2722)
- When running sessions on Kubernetes or Slurm with Singularity, the home page now remembers the container image used most recently and sets it as the default. This includes custom images, when permitted. (rstudio-pro#3601, rstudio-pro#4079)
- When launching a session from the home page on Kubernetes or Slurm, the dropdown for available container images is now better organized and manages long image names more gracefully. (rstudio-pro#5630)
- Opening the job summary for a session on the home page now shows much more detailed information, including the session's host (if available), AWS role and/or Databricks Workspace (if any), queue (on Slurm), platform-native ID (on Slurm and Kubernetes) and resource profile (if applicable). (rstudio-pro#3690, rstudio-pro#5537)
- The Databricks pane is now enabled by default if there are Databricks workspaces configured in the `databricks.conf` file. There is no need to enable it separately. To disable the pane, set `databricks-enabled=0` in the `rserver.conf` file. (rstudio-pro#5556)
- A new icon on the RStudio Pro toolbar shows information on active AWS or Databricks credentials, if present. (rstudio-pro#5860)
- The PostgreSQL password can now be set via environment variable. (rstudio-pro#5332)
- Implemented Posit Product Documentation theme in Posit Workbench Administration Guide, Posit Workbench Licenses, Posit Workbench User Guide, and RStudio Desktop Administration Guide via Quarto extension. (rstudio-pro#5729)
- Performance improvement where nginx handles static files, configurable with nginx.static.conf file. (rstudio-pro#5671)
- VSCode: upgraded coder/code-server to 4.22.1 (VS Code version 1.87.2) on all operating systems except CentOS 7. Upgraded to coder/code-server 4.16.1 (VS Code version 1.80.2) on Centos 7.
- Added preview of Code OSS - with Posit Workbench, pwb-code-server version 2024.04-b31 (VS Code version 1.87.0). (rstudio-pro#3777)
- Robustness and scalability improvements for streaming connections. Close all streaming connections when tabs are invisible, and impose limits on "session output view". Added options for tuning large-scale system performance: launcher-sessions-proxy-timeout-seconds, max-streams-per-user, streaming-connection-timeout-seconds rserver.conf option. . (rstudio-pro#5888, rstudio-pro#5616, rstudio-pro#5771, rstudio-pro#3417)
- Added support for debug, and strace session diagnostics for individual user sessions. Create a file with 'strace' or 'debug' in ~/.config/rsession-diagnostics or ~/.config/pwb/jupyter-diagnostics, vscode-diagnostics. Logs in ~/.local/share/{rstudio,pwb}/log. (rstudio-pro#5529)
- Posit Workbench no longer has a dependency on the `libuser` package. (rstudio-pro#4261)
- Container users that have special characters in their names, such as `@`, can now be created at session start. (rstudio-pro#2714)
- Prometheus metrics are now available as a Preview feature. (rstudio-pro#5793)
- Prometheus metrics can now be enabled or disabled with `metrics-enabled=[1|0]` in `rserver.conf`. (rstudio-pro#5792)
- Prometheus metrics can now be configured. For more details see [Promethes Metrics in the Workbench Admin Guide](https://docs.posit.co/ide/server-pro/2024.04.0/auditing_and_monitoring/prometheus_metrics.html). (rstudio-pro#5791)
- Added support for automatically provisioning users when using Okta or Microsoft Entra ID as an IdP. When using this feature, users can be assigned to Workbench from the IdP and do not need to be created as POSIX users. This feature also supports migrating from local, or ldap/sssd, users to IdP provisioned users. For more details see the [User Provisioning section of the Admin Guide](https://docs.posit.co/ide/server-pro/2024.04.0/user_provisioning/user_provisioning.html). (rstudio-pro#2784)
- Move the force-quit session option into the session info dialog. (rstudio-pro#3385)
- Added support for setting Posit Workbench envrionment variables at the service level in an EnvironmentFile: `/etc/default/rstudio-server`. (rstudio-pro#5337)
- Added support for Slurm with Singularity and Apptainer. (rstudio-pro#5236)
- Updated the Workbench JupyterLab 3 extension to v1.1.738 to upgrade NPM dependencies. (rstudio-pro#5900)

### Fixed

#### RStudio

- Fixed an issue where Stage chunk and Stage line in the Review Changes UI failed in some scenarios. (#5476)
- Fixed shortcut for inserting an assignment operator to work on non-US English keyboards. (#12457)
- Fixed an issue where the menubar would show on secondary windows if Alt key was pressed. (#13973)
- Fixed Windows installer to delete Start Menu shortcut during uninstall. (#13936)
- Fixed current Git branch not always showing correctly in external editor windows. (#14029)
- Fixed the tooltip to show the correct keyboard shortcut when hovering over URLs in the editor. (#12504)
- Fixed Save As dialog on Windows not showing Save As Type field when extensions are hidden. (#12965)
- Fixed GitHub Copilot project preferences not showing the correct status message. (#14064)
- Fixed an issue where Quarto chunk option completions were not displayed at the start of a comment. (#14074)
- Fixed an issue where pipes containing a large number of comments were not indented correctly. (#12674)
- Fixed an issue where RStudio would unnecessarily list directory contents when opening a file. (#14096)
- Localize Copilot-related user interface strings into French. (#14092)
- Improved highlighting of YAML chunk options for Quarto Documents. (#13836)
- Removed obsolete "Use Internet Explorer library/proxy" checkbox from Packages settings. (#13250)
- Improved error handling for Desktop Pro license handling. (rstudio-pro#4873)
- Fixed exception being logged when copying or cutting from the editor in a separate window. (#14140)
- Fixed an issue where RStudio's R diagnostics warned about potentially missing arguments even when disabled via preferences. (#14046)
- Fixed an issue where the Visual Editor's toolbar controls were duplicated on format change. (#12227)
- Fixed regression that caused extra whitespace at the bottom of some popups. (#14223)
- Fixed type dropdowns not working in dataset import when user-interface is in French. (#14224)
- Fixed an issue where RStudio failed to retrieve help for certain S3 methods. (#14232)
- Fixed a regression where the Data Viewer did not display 'variable.labels' for columns. (#14265)
- Fixed an issue where autocompletion help was not properly displayed for development help topics. (#14273)
- Fixed an issue where Shiny onSessionEnded callbacks could be interrupted when stopped in RStudio. (#13394)
- Fixed Copyright date ranges for Release Notes and RStudio IDE User Guide. (#14078)
- Fixed Copyright date ranges for Workbench Administrator and Workbench User Guide, and RStudio Desktop Pro Administration Guide. (#5614)
- Fixed misencoded Hunspell dictionaries. (#8147)
- Fixed an issue where the RStudio debugger failed to step through statements within a tryCatch() call. (#14306)
- Improved responsiveness of C / C++ editor intelligence features when switching Git branches. (#14320)
- If R is not found when starting RStudio Desktop on Linux and macOS, Rstudio Desktop shows an error dialog. (#14343)
- An empty `rstudio-prefs.json` no longer logs spurious JSON parsing errors. (rstudio-pro#4347)
- Fixed Help pane's Next and Previous find-in-topic buttons to have meaningful accessible labels [Accessibility]. (#14347)
- Fixed an issue where the RStudio debugger would re-focus a debugged context over-aggressively. (#10664)
- Fixed handling of duplicated calls in debugger when source references not available. (#14276)
- Fixed issue where stepping through lines of code in tryCatch() would provide incorrect debug highlight. (#14306)
- Fixed an issue where PATH modifications in .Renviron / .Rprofile could be lost on macOS. (#9815)
- Fixed an issue where custom headers were not propagated to `available.packages()` when calling `install.packages()`. (#14282)
- Fixed an issue where code highlight in Sweave \Sexpr{} expressions was incorrectly handled. (#14382)
- Fixed an issue where the Edit button in the Viewer pane could fail for Quarto documents. (#14325)
- Fixed an issue where terminal history would show internal commands. (#9833)
- Fixed an issue where RStudio could fail to launch with Conda builds of R. (#13184)
- Fixed an issue where hovering over S4 class names in the Help pane could produce an R error. (#13344)
- Fixed an issue where defining a custom viewer method produced an R error when View was called. (#14439)
- Fixed an issue where Quarto dashboards could not be previewed if their file path contained a single quote. (#13900)
- Fixed an issue where language objects (calls, formulas) were not described in the Environment pane. (#14446)
- Improved some French translations of the UI.
- Fixed an issue where searches in the Help pane could fail for entries like `[<-`. (#10975)
- Fixed an issue where the "Save workspace on exit" preference was ignored in some cases. (#14258)
- Fixed an issue where the NEWS button in the Update Packages dialog could fail to find the package NEWS file in some cases. (#12648)
- Fixed an issue where Tensorflow object completions were not generated in some contexts. (#14524)
- Fixed an issue in Vim where bracket highlighting followed the bracket behind the cursor when in normal mode. (#4152)
- Fixed an issue where ELECTRON_RUN_AS_NODE was set to true. Thanks to Mykola Grymalyuk of RIPEDA Consulting for reporting this.

#### Posit Workbench
- Fixed an issue where Professional Driver installation could fail on macOS. (rstudio-pro#5168)
- Fixed Copyright date ranges for Workbench Administrator Guide and Workbench User Guide. (rstudio-pro#5865)
- Fixed low-contrast text on Workbench pages [Accessibility]. (rstudio-pro#4464)
- The terminal pane of JupyterLab sessions now respects the user's default shell. (rstudio-pro#5484)
- The Databricks pane now respects the `databricks-enabled=1` setting in the `rserver.conf` file even when running in legacy RStudio Server Pro mode. (rstudio-pro#5695)
- Fixed an issue where pending or failed sessions that were launched on Slurm will no longer erroneously appear in the Workbench Jobs pane on the home page. (rstudio-pro#4846)
- VSCode sessions will now respect the `user-data-dir` option in `vscode.conf` when installing extensions in a user's directory on vscode session startup. (rstudio-pro#6078)
- Fixed an issue where `rstudio-server license-manager deactivate` would emit an error indicating incorrect usage of the `kill` command when `rstudio-server` is already stopped. (rstudio-pro#5549)
- Fixed an error message in the Databricks pane of RStudio Pro sessions when Databricks authentication is not available. (rstudio-pro#5583)
- Fixed an issue where `rstudio-launcher` commands would not work when `RSTUDIO_CONFIG_DIR` or `XDG_CONFIG_DIRS` was set in systemctl overrides. (rstudio-pro#4122)
- Fixed an issue with the permissions on files uploaded from shared projects in RStudio Pro sessions. (rstudio-pro#3134)
- Fixed setting project sharing ACLs on parent directories for projects in subfolders. (rstudio-pro#5309)
- Fixed sporadic CPU usage and crash in rworkspaces. (rstudio-pro#5690)
- Fixed problem with `rstudio-server reload` changing permissions on nginx proxy/body dirs leading to user errors accessing the system. (rstudio-pro#5636)

### Dependencies
- Updated Ace to version 1.32.5. (#14227; Desktop + Server)
- Updated Electron to version 28.2.6. (#14055; Desktop)
- Updated GWT to version 2.10.0. (#11505; Desktop + Server)
- Updated nginx to 1.25.4. (rstudio-pro#5970)
- Updated node.js to version 18.19.1. (#14373, rstudio-pro#5935)
- Updated NSIS to version 3.09. (#14123; Windows Desktop)
- Updated OpenSSL to version 3.1.4. (Windows Desktop)
- Updated Quarto to version 1.4.553. (Desktop + Server)
- Updated zlib to 1.3.1. (rstudio-pro#5971)

### Deprecated / Removed
- Due to the upcoming [end of support for CentOS 7](https://posit.co/about/platform-support/) in June 2024, CentOS 7 builds are no longer available for public download. If you have any questions, please contact Posit Support.
