## RStudio 2023.12.0 "Ocean Storm" Release Notes

### New
#### RStudio
- Updated Ace to version 1.28. (#13708)
- Updated Boost to version 1.83.0. (#13577)
- Updated Electron to version 26.2.4. (#13577)
- Updated the default version of the GitHub Copilot agent to 1.10.3. (#13729)
- Updated openssl to 1.1.1w on Mac and Windows. (#13683)
- Updated Electron Forge to version 6.4.2 and Webpack to version 5.89.0. (rstudio-pro#5383)
- Updated Quarto to version 1.3.450. (#13914)
- RStudio now supports highlighting of inline YAML chunk options in R Markdown / Quarto documents. (#11663)
- Improved support for development documentation when a package has been loaded via `devtools::load_all()`. (#13526)
- RStudio now supports autocompletion following `@` via `.AtNames`. (#13451)
- RStudio now supports the execution and display of GraphViz (`dot`) graphs in R Markdown / Quarto chunks. (#13187)
- RStudio now supports the execution of chunks with the 'file' option set. (#13636)
- With screen reader support enabled, hitting ESC key allows Tabbing away from editor. [accessibility] (#13593)
- RStudio now supports `LuaLaTeX` to compile Sweave/Rnw documents. (#13812)
- Better error message when user preferences fail to save due to folder permissions. (#12974)
- RStudio now supports pasting of file paths for files copied to the clipboard. (#4572)
- RStudio now supports duplicate connection names for Posit drivers. (rstudio-pro#5437)

#### Posit Workbench
- Removed link for opening sessions in RStudio Desktop Pro from Session Info dialog. (rstudio-pro#5263)
- Increased the built-in nginx server's max connection limit, enabled nginx error logging and allow both to be configured (rstudio-pro#4652, rstudio-pro#4747, rstudio-pro#5452)
- Improved Admin: The Logs tab now allows viewing other server log files. A new Server tab provides real-time performance info and on-the-fly adjustment of the rserver log-level (rstudio-pro#5212)
- Added requestTime to nginx access logs when rserver.conf's server-access-log=1. Format for rserver-http-access.log has changed to add a request time field useful for seeing how long it takes rserver to respond to requests. WARNING: if you have code that processes the log file, expect a new field.
- Replaced Administration Guide section PRO markers with Workbench tags. (#5416)
- Added Licenses guide that includes open source software components and full copies of license agreements used by the components. (#5027)
- Restored database password encryption support removed in 2023.09.1 (rstudio-pro#5365)
- Added support for launching jobs via Singularity with Slurm (launcher#447)
- Added Databricks integration to RStudio Pro Sessions which allows users to seamlessly interact with Databricks clusters and resources (rstudio-pro#4927)
- Added Databricks integration to Workbench which enables pass-through auth with Databricks, AWS-Databricks, and Azure Databricks for IDE and VS Code (rstudio-pro#4927)

### Fixed
#### RStudio
- Fixed an issue preventing the object explorer from exploring httr request objects. (#13348)
- RStudio will no longer attempt to automatically activate the default system installation of Python. (#13497)
- Improved performance of R Markdown chunk execution for projects running on networked filesystems. (#8034)
- Fixed an issue where underscores in file names were not displayed correctly in menu items. (#13662)
- Fixed an issue where previewed plots were not rendered at the correct DPI. (#13387)
- Fixed an issue where warnings could be emitted when parsing YAML options within R Markdown code chunks. (#13326)
- Fixed an issue where inline YAML chunk options were not properly parsed from SQL chunks. (#13240)
- Fixed an issue where help text in the autocompletion popup was not selectable. (#13674)
- Fixed an issue where a file could be opened twice when debugging functions sourced from other directories. (#13719)
- Fixed an issue preventing publishing standalone Quarto content from within larger Quarto projects. (#13637)
- Fixed an issue that prevented RStudio from opening PDF vignettes from the Help pane. (#13041)
- Inline chunk execution now respects YAML style plot options styled with hyphens. (#11708)
- Fixed a bug where project options updated in the Project Options pane were not properly persisted in RStudio 2023.09.0. (#13757)
- Improved screen reader support when navigating source files in the editor. [accessibility] (#7337)
- Fixed viewing or blaming file on GitHub for a newly created branch. (#9798)
- Fixed an issue on macOS where '-ne' was erroneously printed to the console with certain versions of Bash. (#13809)
- Fixed an issue where attempts to open files containing non-ASCII characters from the Files pane could fail on Windows. (#13855, #12467)
- Fixed an issue where color highlight for Console input could not be disabled. (#13118)
- Fixed an issue that could cause the RStudio IDE to crash if a large amount of Console output was serialized with a suspended session. (#13857)
- RStudio now records the deployment target for newly-published documents, even when deployment fails due to an error in the document. (#12707)
- Fixed an issue where Find in Files results were not presented in rare cases. (#12657)
- Fixed an issue that could cause errors to occur if an R Markdown document was saved while a chunk was running. (#13860)
- Fixed an issue where console output could be dropped when rendering large ANSI links. (#13869)
- Fixed an issue preventing users from copying code from the History pane. (#3219)
- Fixed WSL terminals not starting on RStudio Desktop for Windows. (#13918)
- Fixed an issue that prevented users from opening files and vignettes with non-ASCII characters in their paths. (#13886)
- Fixed an issue where large, heavily-nested objects could slow down code execution in the R session. (#13965)
- Fixed performance problem locating RStudio projects that live under a large directory tree (rstudio-pro#5435)
- Session Protocol Debug in Tools -> Command Palette turns on log-level=debug when set (rstudio-pro#5095)
- Reduce overhead of session suspension checks and writes to the executing file (#13534, rstudio-pro#4922)
- Reset session keyring on linux platforms to ensure credentials added in a session are isolated (rstudio-pro#5485)

#### Posit Workbench
- Fixed opening job details in new windows more than once for Workbench jobs on the homepage. (rstudio/rstudio-pro#5179)
- Fixed accessibility issues with empty Session and Project lists on the homepage. [accessibility] (rstudio/rstudio-pro#5214)
- Fixed accessibility issues with Project controls on the homepage when not using launcher sessions. [accessibility] (rstudio/rstudio-pro#5215)
- Fixed unlabeled input field in Rename Session modal dialog on the homepage. [accessibility] (rstudio/rstudio-pro#5178)
- Fixed mismatched label on "Join session when ready" checkbox in New Session dialog. [accessibility] (rstudio/rstudio-pro#5221)
- Fixed issue that caused start up crash in environments with encrypted database passwords. (rstudio-pro#5228)
- Fixed an issue where Shift+Tab wouldn't wrap focus in the New Session dialog. [accessibility] (rstudio-pro#4488)
- Fixed an issue where sessions couldn't be started with keyboard with Kubernetes or Slurm. [accessibility] (rstudio-pro#4360)
- Fixed label on button for showing and hiding launcher details so it is available to screen reader. [accessibility] (rstudio-pro#5268)
- Improved the accessible label on launcher job details buttons. [accessibility] (rstudio-pro#5270)
- Fixed an issue where last sign in for user would be updated even if login fails due to license limits (rstudio-pro#5039)
- Fixed bug where vscode and jupyter websockets might be intermittently closed in some circumstances, especially when auth-timeout-minutes=0 (rstudio-pro#5220)
- Fixed routing problem with load balancing when not using a standard port (rstudio-pro#5367)
- Fixed intermittent problem with load balancing and local launcher sessions for some features like workbench jobs (rstudio-pro#5451)
- Reduce number of DB connections allocated in the pool when servers have many cpus (rstudio-pro#5210)
- Fixed issue where homepage did not display RStudio session's 'Executing' status consistently (rstudio-pro#5141)
- Fixed bug in the Posit Workbench VS Code extension that prevented the extension from recognizing all Dash apps (rstudio-workbench-vscode-ext#239)
