## RStudio 2023.09.0 "Desert Sunflower" Release Notes

### New
#### RStudio
- Update to Electron 25.5.0 (#13457)
- Add support Quarto Manuscript projects, a new Quarto feature that will be released in Quarto 1.4.
- Added option to sign Git commits (#1865)
- Add section to theme generation that will use theme-specific color(s) to set colors of vim/emacs-mode cursor

#### Posit Workbench
- An initial set of Prometheus metrics and grafana dashboard are available for the Workbench server (rstudio/rstudio-pro#3273)
- Additional support for publishing new content types to Posit Cloud (rstudio/rstudio-pro#4541)
- Update code-server to version 4.14.1 (VS Code version 1.79.2) bundled with node 16.20.2 (rstudio/rstudio-pro#4774, rstudio/rstudio-pro#5012)
- Update rserver-saml to 0.7.0 (rstudio/rstudio-pro#4903)
- Change the default behavior of the load-balancer configuration setting `launcher-balancing-enabled` to always be true. This has no effect on non load-balanced environments. (rstudio/rstudio-pro#4953)
- Auto-generate the `secure-cookie-key` and launcher key pair in load-balanced environments (rstudio/rstudio-pro#4985)
- Add the `secure-cookie-key` and launcher key pair to the node table of the database for load-balanced environments. (rstudio/rstudio-pro#4985)
- Multiple instances of the Slurm plugin can now point at the same backing cluster without interfering with one another, provided they have different names (rstudio/launcher#706)
- The Slurm plugin now has a `default-partition` setting that allows choosing a different partition than the cluster-wide default. The default partition is also put at the top of the list and highlighted in the UI when launching sessions (rstudio/launcher#551, rstudio/launcher#627, rstudio/rstudio-pro#4658)
- Resource profiles for the Slurm plugin now support setting the partition (rstudio/launcher#695, rstudio/rstudio-pro#4658)
- Resource profiles for the Kubernetes plugin now support setting placement constraints (rstudio/launcher#714, rstudio/rstudio-pro#4767)
- When launching sessions or Workbench jobs, available clusters are now shown only when there is more than one option (rstudio/rstudio-pro#4675)
- Non-shared projects on the home page no longer show a superfluous "Owner" field (rstudio/rstudio-pro#4984)
- Users can now opt to receive desktop notifications when their sessions are ready, which is especially useful on platforms like Slurm or Kubernetes where this may take more than a few seconds (rstudio/rstudio-pro#3432)
- While waiting to auto-join a session from the home page, the popup now shows additional status information on Kubernetes and Slurm and no longer warns about sessions that take more than 30 seconds to start (rstudio/rstudio-pro#4813)
- Projects that can't be found by the server are no longer completely hidden on the home page; rather, they are flagged as potentially moved or deleted (rstudio/rstudio-pro#4958)
- Workbench now sets the `SPARK_CONNECT_USER_AGENT` environment variable for all sessions. This can help users of hosted Apache Spark clusters (including Databricks) identify when Workbench users are accessing Spark (rstudio/rstudio-pro#5015)
- Security audit and file size optimization for VS Code Workbench extension (rstudio/rstudio-workbench-vscode-ext#227)
- Added `delete-node-on-exit` option for load balancing to cleanup node table and fixed error caused by stale nodes (rstudio/rstudio-pro#4888)
- Added explicit load-balancing-enabled option to rserver.conf (rstudio/rstudio-pro#4836)
- Sticky sessions are no longer required to use OpenID Connect authentication (rstudio/rstudio-pro#2451)
- [Performance] Improved performance of group membership tests (rstudio/rstudio-pro#4643)
- [Performance] Increased read buffer size for rserver proxy (rstudio/rstudio-pro#4764)
- [Performance] Various improvements to the responsiveness of the Workbench home page (rstudio/rstudio-pro#4736, rstudio/rstudio-pro#4750, rstudio/rstudio-pro#4762, rstudio/rstudio-pro#4085)
- Fixed rserver CPU bottleneck when session generates lots of output but never starts (rstudio/rstudio-pro#4865)
- [Performance] Avoid username lookups when listing processes looking for sessions (rstudio/rstudio-pro#4800)
- [Performance] Avoid load balancing node-status checks for Slurm and Kubernetes sessions (rstudio/rstudio-pro#4876)

### Fixed
#### RStudio
- Fixed issue where `DYLD_FALLBACK_LIBRARY_PATH` was not properly forwarded on macOS (#13085)
- Fixed issue where 'ggrepel' plot annotations could disappear when a plot was redrawn in an R Markdown document (#4330)
- Fixed issue where whitespace in error messages was not properly preserved (#13239)
- Fixed issue where the Data Viewer could fail to render data.frames containing AsIs matrices (#13215)
- Fixed issue where error messages were not properly translated on Windows in some cases (#10308)
- Fixed issue where Electron menubar commands are not disabled when modals are displayed (#12972)
- Fixed bug causing invalid/empty `cacheKey` error when accessing a dataframe variable (#13188)
- Fixed bug preventing dataframe column navigation past the default number of display columns (#13220)
- Fixed bug preventing files from being saved when user `HOME` path includes trailing slashes on Windows (#13105)
- Fixed broken Help pane after navigating to code demo (#13263)
- Fixed bug preventing Update Available from displaying (#13347)
- Fixed bug causing dataframe help preview to fail for nested objects (#13291)
- Fixed issue where changes to binary files were not presented in Git History view (#13126)
- Fixed bug where clicking "Ignore Update" would fail to ignore the update (#13379)
- Fixed issue with alignment of R argument names in Help pane (#13474)
- Fixed issue where user was not warned of missing Rosetta installation on Apple silicon (#12791)
- Fixed bug with modals disabling copy/paste (#13365)
- Fixed issue with file opened twice when navigating `cli` package hyperlinks (#13134)
- Fixed issue where column names weren't provided as completion candidates for DBI tables. (#12577)
- Fixed an issue where parameter name completions were not provided within `dplyr` joins. (#13415)
- Fixed issue where R sessions containing large 'igraph' objects could become slow (#13489)

#### Posit Workbench 
- Fixed intermittent rsession crash when the linux nscd service was enabled (rstudio/rstudio-pro#4648)
- Fixed bug when resuming session not restoring current working directory for Terminal pane (rstudio/rstudio-pro#4027)
- Fixed bug preventing `HOME` from being modified in system init scripts (rstudio/rstudio-pro#4584)
- Removed unnecessary files from install packages (rstudio/rstudio-pro#4943)
- Updated Launcher go dependencies to latest versions (rstudio/rstudio-pro#5021)
- Workbench will no longer log a spurious error about ownership when the `r-versions` file is on an NFS mount with `root_squash` set (rstudio/rstudio-pro#4721)
- The `launcher-sessions-clusters`, `launcher-adhoc-clusters`, and `launcher-default-cluster` settings now apply to all IDEs. Individual settings for Jupyter and VS Code sessions are now marked as deprecated (rstudio/rstudio-pro#4651)
- Recent projects listed on the home page should no longer have an empty "Last Used" field (rstudio/rstudio-pro#4157)
- The Slurm plugin no longer warns that some legitimately-supported Slurm versions are not supported (rstudio/launcher#644)
- AWS roles can now be chosen when resuming a session as well as launching a new one (rstudio/rstudio-pro#5043)
- Fixed `rstudio-server active-sessions` command and added `node-status` (rstudio/rstudio-pro#4074)
- Fixed load balancing to count all types of sessions (rstudio/rstudio-pro#3016)
- Fixed bug preventing user's last sign in date from updating on CentOS 7 and PostgreSQL (rstudio/rstudio-pro#5072)
- Limit logs collected in rstudio-diagnostics to reduce size

