## RStudio 2022-02.3 "Prairie Trillium" Release Notes


### R

* Fixed issue in R debugger that caused RStudio to lose focus out of source code when interacting with the console in certain ways, such as evaluating an expression (#10664)
* Fixed an issue where files would appear to be blank when opened in projects not using UTF-8 encoding on Windows with R 4.2.0. (#11206)

### Ubuntu 22.04 ("Jammy") and Fedora 35 Compatibility

* Ubuntu Jammy builds of RStudio using libssl3 to enable installation on Ubuntu Jammy Jellyfish 22.04 LTS (#10902)
* Fix incompatibility between QtWebEngine and newer glibc by disabling Chromium sandbox, see disclaimer below (#9854)

### Note on glibc 2.34+ and Chromium Sandbox

For Ubuntu 22.04 ("Jammy"), Fedora 35, and other distros with with newer versions of glibc (>= 2.34) the RStudio Desktop application now disables the Chromium security sandbox in order to workaround a library conflict between the version of chromium used in Qt 5.12 and the platform libraries. The sandbox is a second level security mechanism that prevents untrusted Javascript code from exploiting unknown security problems from using a set of protected system services.

While we will continue to support the Chromium security sandbox for other versions of Linux and in our upcoming Electron version on all platforms, we believe the product security for RStudio Desktop on Ubuntu 22.04 and Fedora 35 will not be significantly affected even with this security feature disabled. Software security is not a perfect science so we want to be clear about the implications so users can make informed choices.

RStudio Desktop is a developer’s tool that is commonly runs custom code outside of the browser sandbox. Users already must take care to trust the code they run, and are protected by the language and library interfaces they use, as well as a trusted supply chain of package managers. RStudio Desktop either accesses all files on the local system, or connects through an explicit process to trusted servers.

See https://chromium.googlesource.com/chromium/src/+/0e94f26e8/docs/linux_sandboxing.md#the-sandbox-1 for more details.
