
## RStudio 2021.09.0 "Ghost Orchid" Release Notes

* Changed from semantic versioning to calendar based versioning (Pro #2652)

### Python

* Projects containing a Python environment are now automatically activated (#9489)


### Logging

* In an effort to help make the RStudio Team products more cohesive, logging has been changed significantly.
* By default, server logs will now be written to file instead of syslog. Warnings and errors will still log to syslog. This can be controlled by the `warn-syslog` parameter in `logging.conf`.
* By default, server logs will now be written under `/var/log/rstudio/rstudio-server`.
* Logs can now be written in JSON lines format.
* Reloading the logging.conf configuration by sending a SIGHUP to the `rserver` process will now cause all RStudio managed subprocesses to also refresh their logging configuration.
* Logging can now be partially configured using environment variables (`RS_LOGGER_TYPE`, `RS_LOG_LEVEL`, `RS_LOG_MESSAGE_FORMAT`, and `RS_LOG_DIR`).
* Log files will now rotate by time in addition to the existing rotation by file size. This can be controlled by the `rotate-days` parameter in `logging.conf`.
* For more information, see section 2 of the Admin Guide.

### RStudio Workbench

* Load-balancing configuration is now automatic, stored in the internal database, and doesn't require editing config files. Added supporting `rstudio-server list-nodes` command to show users the node's status according to the database. (Pro #2167)
* Added `rstudio-server delete-node` command to allow users to remove a load-balancing node from the database (Pro #2800)
* Added AWS Cognito support to OpenID integration (Pro #2313)
* Add file uploads and downloads to session audit log (Pro #2226)
* RStudio Workbench can now run without root access in a single-user mode (Pro #9496)
* Updated embedded nginx in Server Pro to 1.20.1 (Pro #2676)
* Use separate database schema for open source RStudio Server instances (`rstudio-os`) and RStudio Workbench instances (`rstudio`) to avoid conflicts (Pro #2725)
* Prevent user preferences from setting CRAN repos when `allow-cran-repos-edit=0` (Pro #1301)
* Ensure that improperly configured `launcher-sessions-callback-address` values can't hang user sessions (Pro #2532)
* Support username aliases, where two usernames map to the same uid (Pro #2736)

### Bugfixes

* Fixed issue where running Python chunk in notebook did not validate reticulate was installed (#9471)
* Fixed issue where .md, .py, .sql, and .stan files had duplicate event handlers (#9106)
* Fixed issue where output when running tests could be emitted in wrong order in Build pane (#5126)
* Fixed issue where RStudio could crash when viewing a malformed data.frame (#9364)
* Fixed issue where completion tooltip was erroneously shown in multi-line strings in some cases (#8677)
* Fixed issue with autocompletion of column names within native-piped R expressions (#9385)
* Fixed issue where help requests for Python objects would fail with reticulate 1.20 (#9311)
* Fixed issue where busy sessions can't be interrupted and block basic file operations (#2038)
* Fixed issue where R Markdown error output was not properly formatted when displayed (#9390)
* Fixed issue where R Markdown template skeletons with a '.rmd' extension were not discovered (Pro #1607)
* Fixed issue where autocompletion system could emit errors with R (< 3.3.0). (Pro #2680)
* Fixed issues causing multiple background jobs to be created when running Shiny applications in the background (#8746, #6904)
* Fixed issue causing an error when adding files to static content published to RStudio Connect (#9571)
* Fixed issue where R banner could be displayed twice on startup (#6907)
* Fixed issue where RStudio was unable to initialize a Git repository in UNC paths on Windows (#4137)
* Removed the breaking change introduced in Juliet Rose that changed the behavior of the X-Forwarded-Proto header when RSW is behind a proxy server (Pro #2657)
* Fixed issue where adjacent links in the Visual Editor could merge into a single link (#8471)
* Fixed Issue where items deleted from a local Zotero Collection would still appear in the Visual Editor's Insert Citation dialog.
* Fixed issue where Console width was computed incorrectly with some custom fonts (#8696)
* Fixed two 502 errors with load balancing: quick session restart, and failover for non-launcher sessions (Pro #2696)
* Fixed problem with backspace in terminal causing incorrect display (#9249)

### Misc

* **BREAKING:** RStudio Desktop Pro only supports activation with license files (Pro #2300)
* **BREAKING:** The `session-env-var-save-blacklist` option has been renamed to `session-ephemeral-env-vars`.
* **BREAKING:** The `directory-view-whitelist` option has been renamed to `directory-view-allow-list`.
* Update bundled Pandoc to version 2.14.1 
* Depend on new versions of `rmarkdown` (2.10) and `shiny` (1.6)
* Fixed an issue where scroll position in PDFs was not preserved on re-render (#9603)
* Support highlight of 'css' and 'asis' chunks in R Markdown documents (#4821)
* Improved ordering of completion results within `library()` calls (#9293)
* Syntax support for embedded knitr chunks (#9579)
* Add option to synchronize the Files pane with the current working directory in R (#4615)
* Add new *Set Working Directory* command to context menu for source files (#6781)
* Local background jobs can now be replayed (#5548)
* Improved display of R stack traces in R functions invoked internally by RStudio (#9307)
* High DPI ("Retina") plots are now supported on RStudio Server (#3896)
* The "auto-detect indentation" preference is now off by default (#9211) 
* Make the *Use renv with this project* option sticky, and allow setting by admins (Pro #2671)
* RStudio no longer treats R objects containing null external pointers specially when building Environment pane (#5546)
* Make Cmd+Shift+0 the shortcut for restarting session on MacOS (#7695)
* Update Plumber file template for Plumber 1.0 (#9402)
* Support creating supplemental groups when create-container-user=1 (Pro #2276)
* RStudio addins installed within `tools:::R_user_dir(<pkg>, "config")` are now discovered by RStudio. (#9648)
