/*
 * ChunkContextCodeUi.java
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 * Unless you have received this program directly from Posit Software pursuant
 * to the terms of a commercial license agreement with Posit Software, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */
package org.rstudio.studio.client.workbench.views.source.editors.text.rmd;

import org.rstudio.studio.client.workbench.views.source.editors.text.PinnedLineWidget;
import org.rstudio.studio.client.workbench.views.source.editors.text.Scope;
import org.rstudio.studio.client.workbench.views.source.editors.text.TextEditingTarget;
import org.rstudio.studio.client.workbench.views.source.editors.text.ace.LineWidget;

/**
 * Implementation of a R Markdown chunk context toolbar host for code view
 * (inside the text editor)
 */
public class ChunkContextCodeUi extends ChunkContextUi
{
   public ChunkContextCodeUi(TextEditingTarget target, boolean dark, Scope chunk,
                             PinnedLineWidget.Host host, int renderPass)
   {
      super(target, chunk, target.getDocDisplay(), dark);
      
      host_ = host;
      renderPass_ = renderPass;
   }

   @Override
   protected int getRow()
   {
      return lineWidget_.getRow();
   }

   @Override
   protected int getInnerRow()
   {
      return getRow();
   }

   @Override
   protected void createToolbar(int row)
   {
      super.createToolbar(row);

      // Create a new pinned line widget; ensure it always has a host by
      // providing our own host wrapper
      lineWidget_ = new PinnedLineWidget(
            ChunkContextToolbar.LINE_WIDGET_TYPE, outerEditor_.getDocDisplay(), 
            toolbar_, row, null, new PinnedLineWidget.Host()
            {
               @Override
               public void onLineWidgetRemoved(LineWidget widget)
               {
                  if (host_ != null)
                  {
                     host_.onLineWidgetRemoved(widget);
                  }
               }
               
               @Override
               public void onLineWidgetAdded(LineWidget widget)
               {
                  if (host_ != null)
                  {
                     host_.onLineWidgetAdded(widget);
                  }
               }
            });
   }
   
   @Override
   public void runChunk()
   {
      super.runChunk();
      outerEditor_.focus();
   }

   @Override
   public void runPreviousChunks()
   {
      super.runPreviousChunks();
      outerEditor_.focus();
   }

   public LineWidget getLineWidget()
   {
      return lineWidget_.getLineWidget();
   }
   
   public void detach()
   {
      lineWidget_.detach();
   }

   public void setRenderPass(int pass)
   {
      renderPass_ = pass;
   }
   
   public int getRenderPass()
   {
      return renderPass_;
   }

   private PinnedLineWidget lineWidget_;

   private int renderPass_;
   
   private final PinnedLineWidget.Host host_;
}
