/*
 * QuartoConstants.java
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 * Unless you have received this program directly from Posit Software pursuant
 * to the terms of a commercial license agreement with Posit Software, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */

package org.rstudio.studio.client.quarto.model;

public class QuartoCommandConstants
{
   public final static String FORMAT_HTML = "html";
   public final static String FORMAT_PDF = "pdf";
   public final static String FORMAT_DOCX = "docx";
   public final static String FORMAT_REVEALJS = "revealjs";
   public final static String FORMAT_BEAMER = "beamer";
   public final static String FORMAT_PPTX = "pptx";
   
   public final static String INTERACTIVE_SHINY = "shiny";
   public final static String INTERACTIVE_OJS = "ojs";
   
   public final static String PROJECT_DEFAULT = "default";
   public final static String PROJECT_WEBSITE = "website";
   public final static String PROJECT_BOOK = "book";
   public final static String PROJECT_MANUSCRIPT = "manuscript";
   
   public final static String PROJECT_WEBSITE_BLOG = "website:blog";
   
   public final static String ENGINE_MARKDOWN = "markdown";
   public final static String ENGINE_KNITR = "knitr";
   public final static String ENGINE_JUPYTER = "jupyter";
   
   public final static String EDITOR_VISUAL = "visual";
   public final static String EDITOR_SOURCE = "source";
   
   
}
