/*
 * SwitchToProjectEvent.java
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 * Unless you have received this program directly from Posit Software pursuant
 * to the terms of a commercial license agreement with Posit Software, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */
package org.rstudio.studio.client.projects.events;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import org.rstudio.studio.client.application.model.TutorialApiCallContext;

public class SwitchToProjectEvent extends GwtEvent<SwitchToProjectEvent.Handler>
{
   public static final Type<Handler> TYPE = new Type<>();

   public interface Handler extends EventHandler
   {
      void onSwitchToProject(SwitchToProjectEvent event);
   }

   public SwitchToProjectEvent(String project)
   {
      this(project, false);
   }

   public SwitchToProjectEvent(String project, boolean forceSaveAll)
   {
      project_ = project;
      forceSaveAll_ = forceSaveAll;
      callContext_ = null;
   }

   public SwitchToProjectEvent(String project, boolean forceSaveAll, TutorialApiCallContext callContext)
   {
      project_ = project;
      forceSaveAll_ = forceSaveAll;
      callContext_ = callContext;
   }

   public String getProject()
   {
      return project_;
   }

   public boolean getForceSaveAll() { return forceSaveAll_; }

   public TutorialApiCallContext getCallContext()
   {
      return callContext_;
   }

   @Override
   protected void dispatch(Handler handler)
   {
      handler.onSwitchToProject(this);
   }

   @Override
   public Type<Handler> getAssociatedType()
   {
      return TYPE;
   }

   private final String project_;
   private final boolean forceSaveAll_;
   private final TutorialApiCallContext callContext_;
}
