/*
 * PanmirrorXRefServer.java
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 * Unless you have received this program directly from Posit Software pursuant
 * to the terms of a commercial license agreement with Posit Software, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */


package org.rstudio.studio.client.panmirror.server;

import org.rstudio.core.client.promise.PromiseServerRequestCallback;
import org.rstudio.studio.client.RStudioGinjector;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.inject.Inject;

import elemental2.promise.Promise;
import elemental2.promise.Promise.PromiseExecutorCallbackFn.RejectCallbackFn;
import elemental2.promise.Promise.PromiseExecutorCallbackFn.ResolveCallbackFn;
import jsinterop.annotations.JsType;

@JsType
public class PanmirrorXRefServer
{
   public PanmirrorXRefServer() {
      RStudioGinjector.INSTANCE.injectMembers(this);
   }
   
   @Inject
   void initialize(PanmirrorXRefServerOperations server)
   {
      server_ = server;
   }
   
   public Promise<JavaScriptObject> indexForFile(String file)
   {
      return new Promise<>((ResolveCallbackFn<JavaScriptObject> resolve, RejectCallbackFn reject) -> {
         server_.xrefIndexForFile(
            file,
            new PromiseServerRequestCallback<>(resolve, reject)
         );
      });
   }
   
   public Promise<JavaScriptObject> xrefForId(String file, String id)
   {
      return new Promise<>((ResolveCallbackFn<JavaScriptObject> resolve, RejectCallbackFn reject) -> {
         server_.xrefForId(
            file,
            id,
            new PromiseServerRequestCallback<>(resolve, reject)
         );
      });
   }
   
   public Promise<JavaScriptObject> quartoIndexForFile(String file)
   {
      return new Promise<>((ResolveCallbackFn<JavaScriptObject> resolve, RejectCallbackFn reject) -> {
         server_.quartoXrefIndexForFile(
            file,
            new PromiseServerRequestCallback<>(resolve, reject)
         );
      });
   }
   
   public Promise<JavaScriptObject> quartoXrefForId(String file, String id)
   {
      return new Promise<>((ResolveCallbackFn<JavaScriptObject> resolve, RejectCallbackFn reject) -> {
         server_.quartoXrefForId(
            file,
            id,
            new PromiseServerRequestCallback<>(resolve, reject)
         );
      });
   }
   

   private PanmirrorXRefServerOperations server_;
}
