/*
 * VirtualScrollerNative.java
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 * Unless you have received this program directly from Posit Software pursuant
 * to the terms of a commercial license agreement with Posit Software, then
 * this program is licensed to you under the terms of version 3 of the
 * GNU Affero General Public License. This program is distributed WITHOUT
 * ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
 * AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
 *
 */

package org.rstudio.core.client.virtualscroller;

import com.google.gwt.dom.client.Element;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL, name = "VirtualScroller")
public class VirtualScrollerNative
{
   public VirtualScrollerNative() {}
   public native void setup(Element ele, String visuallyHiddenClass);
   public native void append(Element ele);
   public native Element getCurBucket();
   public native boolean scrolledToBottom();
   public native void scrollToBottom();
   public native void clear();
   public native void prune(Element ele);
   public native void ensureStartingOnNewLine();
}

