/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.ForOverride;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.CanCastToVisitor;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class JSType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean resolved = false;
    private JSType resolveResult = null;
    protected TemplateTypeMap templateTypeMap;
    private boolean hashCodeInProgress = false;
    private boolean inTemplatedCheckVisit = false;
    private static final CanCastToVisitor CAN_CAST_TO_VISITOR = new CanCastToVisitor();
    private static final ImmutableSet<String> BIVARIANT_TYPES = ImmutableSet.of("Object", "IArrayLike", "Array");
    private static final ImmutableSet<String> COVARIANT_TYPES = ImmutableSet.of("Iterable", "Iterator", "Generator", "AsyncIterator", "AsyncIterable");
    final JSTypeRegistry registry;

    static final boolean areIdentical(JSType a, JSType b) {
        return a == b;
    }

    JSType(JSTypeRegistry registry) {
        this(registry, null);
    }

    JSType(JSTypeRegistry registry, TemplateTypeMap templateTypeMap) {
        this.registry = registry;
        this.templateTypeMap = templateTypeMap == null ? registry.createTemplateTypeMap(null, null) : templateTypeMap;
    }

    JSType getNativeType(JSTypeNative typeId) {
        return this.registry.getNativeType(typeId);
    }

    public JSDocInfo getJSDocInfo() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public boolean hasDisplayName() {
        String displayName = this.getDisplayName();
        return displayName != null && !displayName.isEmpty();
    }

    public HasPropertyKind getPropertyKind(String pname) {
        return this.getPropertyKind(pname, true);
    }

    public HasPropertyKind getPropertyKind(String pname, boolean autobox) {
        return HasPropertyKind.ABSENT;
    }

    public final boolean hasProperty(String pname) {
        return !this.getPropertyKind(pname, false).equals((Object)HasPropertyKind.ABSENT);
    }

    public boolean isNoType() {
        return false;
    }

    public boolean isNoResolvedType() {
        return false;
    }

    public final boolean isUnresolved() {
        return this.isNoResolvedType();
    }

    public final boolean isUnresolvedOrResolvedUnknown() {
        return this.isNoResolvedType() || this.isNamedType() && this.isUnknownType();
    }

    public boolean isNoObjectType() {
        return false;
    }

    public final boolean isEmptyType() {
        return this.isNoType() || this.isNoObjectType() || this.isNoResolvedType() || JSType.areIdentical(this, this.registry.getNativeFunctionType(JSTypeNative.LEAST_FUNCTION_TYPE));
    }

    public boolean isNumberObjectType() {
        return false;
    }

    public boolean isNumberValueType() {
        return false;
    }

    public boolean isFunctionPrototypeType() {
        return false;
    }

    public boolean isStringObjectType() {
        return false;
    }

    public boolean isSymbolObjectType() {
        return false;
    }

    boolean isTheObjectType() {
        return false;
    }

    public boolean isStringValueType() {
        return false;
    }

    public boolean isSymbolValueType() {
        return false;
    }

    public final boolean isString() {
        return this.isSubtypeOf(this.getNativeType(JSTypeNative.STRING_VALUE_OR_OBJECT_TYPE));
    }

    public final boolean isNumber() {
        return this.isSubtypeOf(this.getNativeType(JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE));
    }

    public final boolean isSymbol() {
        return this.isSubtypeOf(this.getNativeType(JSTypeNative.SYMBOL_VALUE_OR_OBJECT_TYPE));
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isBooleanObjectType() {
        return false;
    }

    public boolean isBooleanValueType() {
        return false;
    }

    public boolean isRegexpType() {
        return false;
    }

    public boolean isDateType() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isVoidType() {
        return false;
    }

    public boolean isAllType() {
        return false;
    }

    public boolean isUnknownType() {
        return false;
    }

    public final boolean isSomeUnknownType() {
        return this.isUnknownType();
    }

    public boolean isCheckedUnknownType() {
        return false;
    }

    public final boolean isUnionType() {
        return this.toMaybeUnionType() != null;
    }

    public boolean isFullyInstantiated() {
        return this.getTemplateTypeMap().isFull();
    }

    public boolean isPartiallyInstantiated() {
        return this.getTemplateTypeMap().isPartiallyFull();
    }

    public boolean isStruct() {
        if (this.isObject()) {
            ObjectType objType = this.toObjectType();
            FunctionType ctor = objType.getConstructor();
            if (ctor == null) {
                JSDocInfo info = objType.getJSDocInfo();
                return info != null && info.makesStructs();
            }
            return ctor.makesStructs();
        }
        return false;
    }

    public boolean isDict() {
        if (this.isObject()) {
            ObjectType objType = this.toObjectType();
            FunctionType ctor = objType.getConstructor();
            if (ctor == null) {
                JSDocInfo info = objType.getJSDocInfo();
                return info != null && info.makesDicts();
            }
            return ctor.makesDicts();
        }
        return false;
    }

    public final boolean isLiteralObject() {
        if (this instanceof PrototypeObjectType) {
            return ((PrototypeObjectType)this).isAnonymous();
        }
        return false;
    }

    public JSType getGreatestSubtypeWithProperty(String propName) {
        return this.registry.getGreatestSubtypeWithProperty(this, propName);
    }

    public UnionType toMaybeUnionType() {
        return null;
    }

    public final boolean isGlobalThisType() {
        return JSType.areIdentical(this, this.registry.getNativeType(JSTypeNative.GLOBAL_THIS));
    }

    public final boolean isFunctionType() {
        return this.toMaybeFunctionType() != null;
    }

    public FunctionType toMaybeFunctionType() {
        return null;
    }

    public FunctionType assertFunctionType() {
        FunctionType result = Preconditions.checkNotNull(this.toMaybeFunctionType(), "not a FunctionType: %s", (Object)this);
        return result;
    }

    public ObjectType assertObjectType() {
        ObjectType result = Preconditions.checkNotNull(this.toMaybeObjectType(), "Not an ObjectType: %s", (Object)this);
        return result;
    }

    public static FunctionType toMaybeFunctionType(JSType type) {
        return type == null ? null : type.toMaybeFunctionType();
    }

    public final boolean isEnumElementType() {
        return this.toMaybeEnumElementType() != null;
    }

    public final JSType getEnumeratedTypeOfEnumElement() {
        EnumElementType e = this.toMaybeEnumElementType();
        return e == null ? null : e.getPrimitiveType();
    }

    public EnumElementType toMaybeEnumElementType() {
        return null;
    }

    public boolean isEnumType() {
        return this.toMaybeEnumType() != null;
    }

    public EnumType toMaybeEnumType() {
        return null;
    }

    public boolean isNamedType() {
        return this.toMaybeNamedType() != null;
    }

    public NamedType toMaybeNamedType() {
        return null;
    }

    public boolean isRecordType() {
        return this.toMaybeRecordType() != null;
    }

    public boolean isStructuralInterface() {
        return false;
    }

    public boolean isStructuralType() {
        return false;
    }

    public RecordType toMaybeRecordType() {
        return null;
    }

    public final boolean isTemplatizedType() {
        return this.toMaybeTemplatizedType() != null;
    }

    public final boolean isGenericObjectType() {
        return this.isTemplatizedType();
    }

    public TemplatizedType toMaybeTemplatizedType() {
        return null;
    }

    public final boolean isTemplateType() {
        return this.toMaybeTemplateType() != null;
    }

    public final boolean isTypeVariable() {
        return this.isTemplateType();
    }

    public TemplateType toMaybeTemplateType() {
        return null;
    }

    public boolean hasAnyTemplateTypes() {
        if (!this.inTemplatedCheckVisit) {
            this.inTemplatedCheckVisit = true;
            boolean result = this.hasAnyTemplateTypesInternal();
            this.inTemplatedCheckVisit = false;
            return result;
        }
        return false;
    }

    boolean hasAnyTemplateTypesInternal() {
        return this.templateTypeMap.hasAnyTemplateTypesInternal();
    }

    public TemplateTypeMap getTemplateTypeMap() {
        return this.templateTypeMap;
    }

    public final ImmutableSet<JSType> getTypeParameters() {
        ImmutableSet.Builder params = ImmutableSet.builder();
        for (TemplateType type : this.getTemplateTypeMap().getTemplateKeys()) {
            params.add(type);
        }
        return params.build();
    }

    public void extendTemplateTypeMap(TemplateTypeMap otherMap) {
        this.templateTypeMap = this.templateTypeMap.extend(otherMap);
    }

    public boolean isObject() {
        return false;
    }

    public final boolean isObjectType() {
        return this.isObject();
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isNominalType() {
        return false;
    }

    public final boolean isNominalConstructor() {
        if (this.isConstructor() || this.isInterface()) {
            FunctionType fn = this.toMaybeFunctionType();
            if (fn == null) {
                return false;
            }
            if (fn.getSource() != null) {
                return true;
            }
            return fn.isNativeObjectType();
        }
        return false;
    }

    public boolean isNativeObjectType() {
        return false;
    }

    public boolean isInstanceType() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isOrdinaryFunction() {
        return false;
    }

    public boolean equals(@Nullable Object jsType) {
        return jsType instanceof JSType && this.isEquivalentTo((JSType)jsType);
    }

    public final boolean isEquivalentTo(@Nullable JSType that) {
        return this.isEquivalentTo(that, false);
    }

    public final boolean isEquivalentTo(@Nullable JSType that, boolean isStructural) {
        EqCache eqCache = isStructural ? EqCache.create() : EqCache.createWithoutStructuralTyping();
        return this.checkEquivalenceHelper(that, EquivalenceMethod.IDENTITY, eqCache);
    }

    public static final boolean isEquivalent(@Nullable JSType typeA, @Nullable JSType typeB) {
        return typeA == null ? typeB == null : typeA.isEquivalentTo(typeB);
    }

    public final boolean differsFrom(JSType that) {
        return !this.checkEquivalenceHelper(that, EquivalenceMethod.DATA_FLOW, EqCache.create());
    }

    @Deprecated
    boolean checkEquivalenceHelper(JSType that, EquivalenceMethod eqMethod) {
        return this.checkEquivalenceHelper(that, eqMethod, EqCache.create());
    }

    boolean checkEquivalenceHelper(@Nullable JSType that, EquivalenceMethod eqMethod, EqCache eqCache) {
        if (that == null) {
            return false;
        }
        if (JSType.areIdentical(this, that)) {
            return true;
        }
        if (this.isNoResolvedType() && that.isNoResolvedType()) {
            if (this.isNamedType() && that.isNamedType()) {
                return Objects.equals(this.toMaybeNamedType().getReferenceName(), that.toMaybeNamedType().getReferenceName());
            }
            return true;
        }
        boolean thisUnknown = this.isUnknownType();
        boolean thatUnknown = that.isUnknownType();
        if (thisUnknown || thatUnknown) {
            if (eqMethod == EquivalenceMethod.INVARIANT) {
                return true;
            }
            if (eqMethod == EquivalenceMethod.DATA_FLOW) {
                return thisUnknown && thatUnknown;
            }
            if (thisUnknown && thatUnknown && this.isNominalType() ^ that.isNominalType()) {
                return false;
            }
        }
        if (this.isUnionType() && that.isUnionType()) {
            return this.toMaybeUnionType().checkUnionEquivalenceHelper(that.toMaybeUnionType(), eqMethod, eqCache);
        }
        if (this.isFunctionType() && that.isFunctionType()) {
            return this.toMaybeFunctionType().checkFunctionEquivalenceHelper(that.toMaybeFunctionType(), eqMethod, eqCache);
        }
        if (!this.getTemplateTypeMap().checkEquivalenceHelper(that.getTemplateTypeMap(), eqMethod, eqCache, SubtypingMode.NORMAL)) {
            return false;
        }
        if (eqCache.shouldMatchStructurally(this, that)) {
            return this.toMaybeObjectType().checkStructuralEquivalenceHelper(that.toMaybeObjectType(), eqMethod, eqCache);
        }
        if (this.isNominalType() && that.isNominalType()) {
            String nameOfThis = this.deepestResolvedTypeNameOf(this.toObjectType());
            String nameOfThat = this.deepestResolvedTypeNameOf(that.toObjectType());
            if (nameOfThis != null || nameOfThat != null) {
                return Objects.equals(nameOfThis, nameOfThat);
            }
        }
        if (this.isTemplateType() && that.isTemplateType()) {
            return false;
        }
        if (this instanceof ProxyObjectType) {
            return ((ProxyObjectType)this).getReferencedTypeInternal().checkEquivalenceHelper(that, eqMethod, eqCache);
        }
        if (that instanceof ProxyObjectType) {
            return this.checkEquivalenceHelper(((ProxyObjectType)that).getReferencedTypeInternal(), eqMethod, eqCache);
        }
        return false;
    }

    @Nullable
    private String deepestResolvedTypeNameOf(ObjectType objType) {
        if (!objType.isResolved() || !(objType instanceof ProxyObjectType)) {
            return objType.getReferenceName();
        }
        ObjectType internal = ((ProxyObjectType)objType).getReferencedObjTypeInternal();
        return internal != null && internal.isNominalType() ? this.deepestResolvedTypeNameOf(internal) : null;
    }

    public final int hashCode() {
        if (this.hashCodeInProgress) {
            return -1;
        }
        this.hashCodeInProgress = true;
        int hashCode = this.recursionUnsafeHashCode();
        this.hashCodeInProgress = false;
        return hashCode;
    }

    abstract int recursionUnsafeHashCode();

    public boolean matchesNumberContext() {
        return false;
    }

    public boolean matchesStringContext() {
        return false;
    }

    public boolean matchesSymbolContext() {
        return false;
    }

    public boolean matchesObjectContext() {
        return false;
    }

    @Nullable
    public final JSType findPropertyType(String propertyName) {
        JSType propertyType = this.findPropertyTypeWithoutConsideringTemplateTypes(propertyName);
        if (propertyType == null) {
            return null;
        }
        if (this.getTemplateTypeMap().isEmpty() || !propertyType.hasAnyTemplateTypes()) {
            return propertyType;
        }
        TemplateTypeMap typeMap = this.getTemplateTypeMap();
        TemplateTypeMapReplacer replacer = new TemplateTypeMapReplacer(this.registry, typeMap);
        return propertyType.visit(replacer);
    }

    @Nullable
    @ForOverride
    protected JSType findPropertyTypeWithoutConsideringTemplateTypes(String propertyName) {
        ObjectType autoboxObjType = ObjectType.cast(this.autoboxesTo());
        if (autoboxObjType != null) {
            return autoboxObjType.findPropertyType(propertyName);
        }
        return null;
    }

    public boolean canBeCalled() {
        return false;
    }

    public final boolean canCastTo(JSType that) {
        return this.visit(CAN_CAST_TO_VISITOR, that);
    }

    public JSType autoboxesTo() {
        return null;
    }

    public boolean isBoxableScalar() {
        return this.autoboxesTo() != null;
    }

    public JSType unboxesTo() {
        return null;
    }

    public ObjectType toObjectType() {
        return this instanceof ObjectType ? (ObjectType)this : null;
    }

    public JSType autobox() {
        JSType restricted = this.restrictByNotNullOrUndefined();
        JSType autobox = restricted.autoboxesTo();
        return autobox == null ? restricted : autobox;
    }

    @Nullable
    public final ObjectType dereference() {
        return this.autobox().toObjectType();
    }

    public final boolean canTestForEqualityWith(JSType that) {
        return this.testForEquality(that).equals((Object)TernaryValue.UNKNOWN);
    }

    public TernaryValue testForEquality(JSType that) {
        return this.testForEqualityHelper(this, that);
    }

    final TernaryValue testForEqualityHelper(JSType aType, JSType bType) {
        if (bType.isAllType() || bType.isUnknownType() || bType.isNoResolvedType() || aType.isAllType() || aType.isUnknownType() || aType.isNoResolvedType()) {
            return TernaryValue.UNKNOWN;
        }
        boolean aIsEmpty = aType.isEmptyType();
        boolean bIsEmpty = bType.isEmptyType();
        if (aIsEmpty || bIsEmpty) {
            if (aIsEmpty && bIsEmpty) {
                return TernaryValue.TRUE;
            }
            return TernaryValue.UNKNOWN;
        }
        if (aType.isFunctionType() || bType.isFunctionType()) {
            JSType otherType;
            JSType jSType = otherType = aType.isFunctionType() ? bType : aType;
            if (otherType.isSymbol()) {
                return TernaryValue.FALSE;
            }
            JSType meet = otherType.getGreatestSubtype(this.getNativeType(JSTypeNative.OBJECT_TYPE));
            if (meet.isNoType() || meet.isNoObjectType()) {
                return TernaryValue.FALSE;
            }
            return TernaryValue.UNKNOWN;
        }
        if (bType.isEnumElementType() || bType.isUnionType()) {
            return bType.testForEquality(aType);
        }
        if (aType.isSymbol()) {
            return bType.canCastTo(this.getNativeType(JSTypeNative.SYMBOL_VALUE_OR_OBJECT_TYPE)) ? TernaryValue.UNKNOWN : TernaryValue.FALSE;
        }
        if (bType.isSymbol()) {
            return aType.canCastTo(this.getNativeType(JSTypeNative.SYMBOL_VALUE_OR_OBJECT_TYPE)) ? TernaryValue.UNKNOWN : TernaryValue.FALSE;
        }
        return null;
    }

    public final boolean canTestForShallowEqualityWith(JSType that) {
        if (this.isEmptyType() || that.isEmptyType()) {
            return this.isSubtypeOf(that) || that.isSubtypeOf(this);
        }
        JSType inf = this.getGreatestSubtype(that);
        return !inf.isEmptyType() || JSType.areIdentical(inf, this.registry.getNativeType(JSTypeNative.LEAST_FUNCTION_TYPE));
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isVoidable() {
        return false;
    }

    public boolean isExplicitlyVoidable() {
        return false;
    }

    public JSType collapseUnion() {
        return this;
    }

    public JSType getLeastSupertype(JSType that) {
        if (JSType.areIdentical(this, that)) {
            return this;
        }
        if ((that = JSType.filterNoResolvedType(that)).isUnionType()) {
            return that.toMaybeUnionType().getLeastSupertype(this);
        }
        return JSType.getLeastSupertype(this, that);
    }

    static JSType getLeastSupertype(JSType thisType, JSType thatType) {
        boolean areEquivalent = thisType.isEquivalentTo(thatType);
        return areEquivalent ? thisType : JSType.filterNoResolvedType(thisType.registry.createUnionType(thisType, thatType));
    }

    public JSType meetWith(JSType that) {
        return JSType.getGreatestSubtype(this, that);
    }

    public JSType getGreatestSubtype(JSType that) {
        return JSType.getGreatestSubtype(this, that);
    }

    static JSType getGreatestSubtype(JSType thisType, JSType thatType) {
        JSType inf;
        if (thisType.isFunctionType() && thatType.isFunctionType()) {
            return thisType.toMaybeFunctionType().supAndInfHelper(thatType.toMaybeFunctionType(), false);
        }
        if (thisType.isEquivalentTo(thatType)) {
            return thisType;
        }
        if (thisType.isUnknownType() || thatType.isUnknownType()) {
            return thisType.isEquivalentTo(thatType) ? thisType : thisType.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (thisType.isUnionType()) {
            return thisType.toMaybeUnionType().meet(thatType);
        }
        if (thatType.isUnionType()) {
            return thatType.toMaybeUnionType().meet(thisType);
        }
        if (thisType.isTemplatizedType()) {
            return thisType.toMaybeTemplatizedType().getGreatestSubtypeHelper(thatType);
        }
        if (thatType.isTemplatizedType()) {
            return thatType.toMaybeTemplatizedType().getGreatestSubtypeHelper(thisType);
        }
        if (thisType.isSubtypeOf(thatType)) {
            return JSType.filterNoResolvedType(thisType);
        }
        if (thatType.isSubtypeOf(thisType)) {
            return JSType.filterNoResolvedType(thatType);
        }
        if (thisType.isRecordType()) {
            return thisType.toMaybeRecordType().getGreatestSubtypeHelper(thatType);
        }
        if (thatType.isRecordType()) {
            return thatType.toMaybeRecordType().getGreatestSubtypeHelper(thisType);
        }
        if (thisType.isEnumElementType()) {
            JSType inf2 = thisType.toMaybeEnumElementType().meet(thatType);
            if (inf2 != null) {
                return inf2;
            }
        } else if (thatType.isEnumElementType() && (inf = thatType.toMaybeEnumElementType().meet(thisType)) != null) {
            return inf;
        }
        if (thisType.isObject() && thatType.isObject()) {
            return thisType.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return thisType.getNativeType(JSTypeNative.NO_TYPE);
    }

    static JSType filterNoResolvedType(JSType type) {
        if (type.isNoResolvedType()) {
            return type.getNativeType(JSTypeNative.NO_RESOLVED_TYPE);
        }
        if (type.isUnionType()) {
            UnionType unionType = type.toMaybeUnionType();
            boolean needsFiltering = false;
            ImmutableList<JSType> alternatesList = unionType.getAlternates();
            for (int i = 0; i < alternatesList.size(); ++i) {
                JSType alt = (JSType)alternatesList.get(i);
                if (!alt.isNoResolvedType()) continue;
                needsFiltering = true;
                break;
            }
            if (needsFiltering) {
                UnionTypeBuilder builder = UnionTypeBuilder.create(type.registry);
                builder.addAlternate(type.getNativeType(JSTypeNative.NO_RESOLVED_TYPE));
                for (int i = 0; i < alternatesList.size(); ++i) {
                    JSType alt = (JSType)alternatesList.get(i);
                    if (alt.isNoResolvedType()) continue;
                    builder.addAlternate(alt);
                }
                return builder.build();
            }
        }
        return type;
    }

    public JSType getRestrictedTypeGivenToBooleanOutcome(boolean outcome) {
        if (outcome && JSType.areIdentical(this, this.getNativeType(JSTypeNative.UNKNOWN_TYPE))) {
            return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
        }
        BooleanLiteralSet literals = this.getPossibleToBooleanOutcomes();
        if (literals.contains(outcome)) {
            return this;
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    public abstract BooleanLiteralSet getPossibleToBooleanOutcomes();

    public TypePair getTypesUnderEquality(JSType that) {
        if (that.isUnionType()) {
            TypePair p = that.toMaybeUnionType().getTypesUnderEquality(this);
            return new TypePair(p.typeB, p.typeA);
        }
        switch (this.testForEquality(that)) {
            case FALSE: {
                return new TypePair(null, null);
            }
            case TRUE: 
            case UNKNOWN: {
                return new TypePair(this, that);
            }
        }
        throw new IllegalStateException();
    }

    public TypePair getTypesUnderInequality(JSType that) {
        if (that.isUnionType()) {
            TypePair p = that.toMaybeUnionType().getTypesUnderInequality(this);
            return new TypePair(p.typeB, p.typeA);
        }
        switch (this.testForEquality(that)) {
            case TRUE: {
                JSType noType = this.getNativeType(JSTypeNative.NO_TYPE);
                return new TypePair(noType, noType);
            }
            case FALSE: 
            case UNKNOWN: {
                return new TypePair(this, that);
            }
        }
        throw new IllegalStateException();
    }

    public TypePair getTypesUnderShallowEquality(JSType that) {
        JSType commonType = this.getGreatestSubtype(that);
        return new TypePair(commonType, commonType);
    }

    public TypePair getTypesUnderShallowInequality(JSType that) {
        if (that.isUnionType()) {
            TypePair p = that.toMaybeUnionType().getTypesUnderShallowInequality(this);
            return new TypePair(p.typeB, p.typeA);
        }
        if (this.isNullType() && that.isNullType() || this.isVoidType() && that.isVoidType()) {
            return new TypePair(null, null);
        }
        return new TypePair(this, that);
    }

    public Iterable<JSType> getUnionMembers() {
        return this.isUnionType() ? this.toMaybeUnionType().getAlternates() : null;
    }

    public JSType restrictByNotNullOrUndefined() {
        return this;
    }

    public JSType restrictByNotUndefined() {
        return this;
    }

    public boolean isSubtypeWithoutStructuralTyping(JSType that) {
        return this.isSubtype(that, ImplCache.createWithoutStructuralTyping(), SubtypingMode.NORMAL);
    }

    public boolean isSubtype(JSType that) {
        return JSType.isSubtypeHelper(this, that, ImplCache.create(), SubtypingMode.NORMAL);
    }

    public boolean isSubtype(JSType that, SubtypingMode mode) {
        return this.isSubtype(that, ImplCache.create(), mode);
    }

    protected boolean isSubtype(JSType that, ImplCache implicitImplCache, SubtypingMode subtypingMode) {
        return JSType.isSubtypeHelper(this, that, implicitImplCache, subtypingMode);
    }

    static boolean isSubtypeHelper(JSType thisType, JSType thatType, ImplCache implicitImplCache, SubtypingMode subtypingMode) {
        Preconditions.checkNotNull(thisType);
        if (thatType.isUnknownType()) {
            return true;
        }
        if (thatType.isAllType()) {
            return true;
        }
        if (thisType.isEquivalentTo(thatType, implicitImplCache.isStructuralTyping())) {
            return true;
        }
        if (thatType.isUnionType()) {
            UnionType union = thatType.toMaybeUnionType();
            ImmutableList<JSType> alternates = union.getAlternates();
            for (int i = 0; i < alternates.size(); ++i) {
                JSType element = (JSType)alternates.get(i);
                if (!thisType.isSubtype(element, implicitImplCache, subtypingMode)) continue;
                return true;
            }
            return false;
        }
        if (subtypingMode == SubtypingMode.IGNORE_NULL_UNDEFINED && (thisType.isNullType() || thisType.isVoidType())) {
            return true;
        }
        TemplateTypeMap thisTypeParams = thisType.getTemplateTypeMap();
        TemplateTypeMap thatTypeParams = thatType.getTemplateTypeMap();
        boolean templateMatch = true;
        if (JSType.isBivariantType(thatType)) {
            JSType thatElement;
            TemplateType key = thisType.registry.getObjectElementKey();
            JSType thisElement = thisTypeParams.getResolvedTemplateType(key);
            templateMatch = thisElement.isSubtype(thatElement = thatTypeParams.getResolvedTemplateType(key), implicitImplCache, subtypingMode) || thatElement.isSubtype(thisElement, implicitImplCache, subtypingMode);
        } else {
            TemplateType covariantKey = JSType.getTemplateKeyIfCovariantType(thatType);
            if (covariantKey != null) {
                JSType thisElement = thisTypeParams.getResolvedTemplateType(covariantKey);
                JSType thatElement = thatTypeParams.getResolvedTemplateType(covariantKey);
                templateMatch = thisElement.isSubtype(thatElement, implicitImplCache, subtypingMode);
            } else {
                templateMatch = thisTypeParams.checkEquivalenceHelper(thatTypeParams, EquivalenceMethod.INVARIANT, subtypingMode);
            }
        }
        if (!templateMatch) {
            return false;
        }
        if (implicitImplCache.shouldMatchStructurally(thisType, thatType)) {
            return thisType.toMaybeObjectType().isStructuralSubtype(thatType.toMaybeObjectType(), implicitImplCache, subtypingMode);
        }
        if (thisType.isTemplatizedType()) {
            return thisType.toMaybeTemplatizedType().getReferencedType().isSubtype(thatType, implicitImplCache, subtypingMode);
        }
        if (thatType instanceof ProxyObjectType) {
            return thisType.isSubtype(((ProxyObjectType)thatType).getReferencedTypeInternal(), implicitImplCache, subtypingMode);
        }
        return false;
    }

    static boolean isBivariantType(JSType type) {
        ObjectType unwrapped = JSType.getObjectTypeIfNative(type);
        return unwrapped != null && BIVARIANT_TYPES.contains(unwrapped.getReferenceName());
    }

    @Nullable
    static TemplateType getTemplateKeyIfCovariantType(JSType type) {
        TemplatizedType ttype;
        if (type.isTemplatizedType() && (ttype = type.toMaybeTemplatizedType()).getTemplateTypeMap().hasTemplateKey(ttype.registry.getIThenableTemplate())) {
            return ttype.registry.getIThenableTemplate();
        }
        ObjectType unwrapped = JSType.getObjectTypeIfNative(type);
        if (unwrapped != null && COVARIANT_TYPES.contains(unwrapped.getReferenceName())) {
            return Iterables.getOnlyElement(unwrapped.getConstructor().getTemplateTypeMap().getTemplateKeys());
        }
        return null;
    }

    @Nullable
    private static ObjectType getObjectTypeIfNative(JSType type) {
        ObjectType objType = type.toObjectType();
        ObjectType unwrapped = ObjectType.deeplyUnwrap(objType);
        return unwrapped != null && unwrapped.isNativeObjectType() ? unwrapped : null;
    }

    public abstract <T> T visit(Visitor<T> var1);

    abstract <T> T visit(RelationshipVisitor<T> var1, JSType var2);

    public final JSType resolve(ErrorReporter reporter) {
        if (this.resolved) {
            if (this.resolveResult == null) {
                return this;
            }
            return this.resolveResult;
        }
        this.resolved = true;
        this.resolveResult = this.resolveInternal(reporter);
        this.resolveResult.setResolvedTypeInternal(this.resolveResult);
        return this.resolveResult;
    }

    abstract JSType resolveInternal(ErrorReporter var1);

    void setResolvedTypeInternal(JSType type) {
        this.resolveResult = type;
        this.resolved = true;
    }

    public final boolean isResolved() {
        return this.resolved;
    }

    public final boolean isSuccessfullyResolved() {
        return this.isResolved() && !this.isNoResolvedType();
    }

    public final boolean isUnsuccessfullyResolved() {
        return this.isResolved() && this.isNoResolvedType();
    }

    static final JSType safeResolve(JSType type, ErrorReporter reporter) {
        return type == null ? null : type.resolve(reporter);
    }

    public boolean setValidator(Predicate<JSType> validator) {
        return validator.apply(this);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(), false).toString();
    }

    public String toDebugHashCodeString() {
        return "{" + this.hashCode() + "}";
    }

    public final String toAnnotationString(Nullability nullability) {
        return nullability == Nullability.EXPLICIT ? this.appendAsNonNull(new StringBuilder(), true).toString() : this.appendTo(new StringBuilder(), true).toString();
    }

    final StringBuilder appendAsNonNull(StringBuilder sb, boolean forAnnotations) {
        if (!(!forAnnotations || !this.isObject() || this.isUnknownType() || this.isTemplateType() || this.isRecordType() || this.isFunctionType() || this.isUnionType() || this.isLiteralObject())) {
            sb.append("!");
        }
        return this.appendTo(sb, forAnnotations);
    }

    abstract StringBuilder appendTo(StringBuilder var1, boolean var2);

    public void matchConstraint(JSType constraint) {
    }

    public boolean isSubtypeOf(JSType other) {
        return this.isSubtype(other);
    }

    public ObjectType toMaybeObjectType() {
        return this.toObjectType();
    }

    public JSType getInstantiatedTypeArgument(JSType supertype) {
        TemplateType templateType = Iterables.getOnlyElement(supertype.getTemplateTypeMap().getTemplateKeys());
        return this.getTemplateTypeMap().getResolvedTemplateType(templateType);
    }

    JSType simplifyForOptimizations() {
        return this;
    }

    public static enum Nullability {
        EXPLICIT,
        IMPLICIT;

    }

    static class ImplCache
    extends MatchCache {
        private HashMap<Key, MatchStatus> matchCache;
        private EqCache eqCache;

        static ImplCache create() {
            return new ImplCache(true);
        }

        static ImplCache createWithoutStructuralTyping() {
            return new ImplCache(false);
        }

        private ImplCache(boolean isStructuralTyping) {
            super(isStructuralTyping);
        }

        boolean updateCache(JSType subType, JSType superType, MatchStatus isMatch) {
            this.matchCache.put(new Key(subType, superType), isMatch);
            return isMatch.subtypeValue();
        }

        MatchStatus checkCache(JSType subType, JSType superType) {
            if (this.matchCache == null) {
                this.matchCache = new HashMap();
            }
            return this.matchCache.putIfAbsent(new Key(subType, superType), MatchStatus.PROCESSING);
        }

        boolean shouldMatchStructurally(JSType subType, JSType superType) {
            return this.isStructuralTyping() && subType.isObject() && superType.isStructuralType();
        }

        private boolean equal(JSType left, JSType right) {
            if (this.eqCache == null) {
                this.eqCache = new EqCache(this.isStructuralTyping());
            }
            return left.checkEquivalenceHelper(right, EquivalenceMethod.IDENTITY, this.eqCache);
        }

        private final class Key {
            final JSType left;
            final JSType right;
            final int hashCode;

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object other) {
                Key that = (Key)other;
                if (this.left == that.left && this.right == that.right) {
                    return true;
                }
                return ImplCache.this.equal(this.left, that.left) && ImplCache.this.equal(this.right, that.right);
            }

            Key(JSType left, JSType right) {
                this.left = left;
                this.right = right;
                this.hashCode = 31 * left.hashCode() + right.hashCode();
            }
        }
    }

    static class EqCache
    extends MatchCache {
        private HashMap<Key, MatchStatus> matchCache;

        static EqCache create() {
            return new EqCache(true);
        }

        static EqCache createWithoutStructuralTyping() {
            return new EqCache(false);
        }

        private EqCache(boolean isStructuralTyping) {
            super(isStructuralTyping);
        }

        void updateCache(JSType left, JSType right, MatchStatus isMatch) {
            this.updateCacheAnyType(left, right, isMatch);
        }

        void updateCache(TemplateTypeMap left, TemplateTypeMap right, MatchStatus isMatch) {
            this.updateCacheAnyType(left, right, isMatch);
        }

        private void updateCacheAnyType(Object left, Object right, MatchStatus isMatch) {
            if (left == right) {
                return;
            }
            this.getMatchCache().put(new Key(left, right), isMatch);
        }

        @Nullable
        MatchStatus checkCache(JSType left, JSType right) {
            return this.checkCacheAnyType(left, right);
        }

        @Nullable
        MatchStatus checkCache(TemplateTypeMap left, TemplateTypeMap right) {
            return this.checkCacheAnyType(left, right);
        }

        private MatchStatus checkCacheAnyType(Object left, Object right) {
            if (left == right) {
                return MatchStatus.MATCH;
            }
            return this.getMatchCache().putIfAbsent(new Key(left, right), MatchStatus.PROCESSING);
        }

        private HashMap<Key, MatchStatus> getMatchCache() {
            if (this.matchCache == null) {
                this.matchCache = new HashMap();
            }
            return this.matchCache;
        }

        boolean shouldMatchStructurally(JSType left, JSType right) {
            return this.isStructuralTyping() ? left.isStructuralType() && right.isStructuralType() : left.isRecordType() && right.isRecordType();
        }

        private static final class Key {
            private final Object left;
            private final Object right;
            private final int hashCode;

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object other) {
                Key that = (Key)other;
                if (this == other) {
                    return true;
                }
                return this.left == that.left & this.right == that.right | this.left == that.right & this.right == that.left;
            }

            Key(Object left, Object right) {
                this.left = left;
                this.right = right;
                this.hashCode = System.identityHashCode(left) ^ System.identityHashCode(right);
            }
        }
    }

    private static abstract class MatchCache {
        private final boolean isStructuralTyping;

        MatchCache(boolean isStructuralTyping) {
            this.isStructuralTyping = isStructuralTyping;
        }

        boolean isStructuralTyping() {
            return this.isStructuralTyping;
        }
    }

    static enum MatchStatus {
        MATCH(true),
        NOT_MATCH(false),
        PROCESSING(true);

        private final boolean isSubtype;

        private MatchStatus(boolean isSubtype) {
            this.isSubtype = isSubtype;
        }

        boolean subtypeValue() {
            return this.isSubtype;
        }

        static MatchStatus valueOf(boolean match) {
            return match ? MATCH : NOT_MATCH;
        }
    }

    public static class TypePair {
        public final JSType typeA;
        public final JSType typeB;

        public TypePair(JSType typeA, JSType typeB) {
            this.typeA = typeA;
            this.typeB = typeB;
        }
    }

    public static enum SubtypingMode {
        NORMAL,
        IGNORE_NULL_UNDEFINED;

    }

    public static enum HasPropertyKind {
        ABSENT,
        KNOWN_PRESENT,
        MAYBE_PRESENT;


        public static HasPropertyKind of(boolean has) {
            return has ? KNOWN_PRESENT : ABSENT;
        }
    }
}

