/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@GwtIncompatible(value="java.util.regex")
public final class JsFileParser
extends JsFileLineParser {
    private static final Logger logger = Logger.getLogger(JsFileParser.class.getName());
    private static final Pattern GOOG_PROVIDE_REQUIRE_PATTERN = Pattern.compile("(?:^|;)(?:[a-zA-Z0-9$_,:{}\\s]+=)?\\s*goog\\.(?<func>provide|module|require|requireType|addDependency|declareModuleId)\\s*\\((?<args>.*?)\\)");
    private static final Pattern ES6_MODULE_PATTERN = Pattern.compile("^(?:import|export)\\b\\s*(?:[a-zA-Z0-9$_*,{}\\s]+\\bfrom\\s*|)(?:['\"]([^'\"]+)['\"])?\\s*;");
    private static final Pattern ES6_EXPORT_PATTERN = Pattern.compile("^export\\b");
    private static final String PROVIDES_GOOG_COMMENT = "@provideGoog";
    private static final String EXTERNS_COMMENT = "@externs";
    private static final String NOCOMPILE_COMMENT = "@nocompile";
    private static final String BUNDLED_GOOG_MODULE_START = "goog.loadModule(function(";
    private final Matcher googMatcher = GOOG_PROVIDE_REQUIRE_PATTERN.matcher("");
    private final Matcher es6Matcher = ES6_MODULE_PATTERN.matcher("");
    private List<String> provides;
    private List<DependencyInfo.Require> requires;
    private List<String> typeRequires;
    private boolean fileHasProvidesOrRequires;
    private boolean hasExternsAnnotation;
    private boolean hasNoCompileAnnotation;
    private ModuleLoader loader = ModuleLoader.EMPTY;
    private ModuleLoader.ModulePath file;
    private ModuleType moduleType;
    private boolean seenLoadModule = false;
    private boolean includeGoogBase = false;

    public JsFileParser(ErrorManager errorManager) {
        super(errorManager);
    }

    public JsFileParser setIncludeGoogBase(boolean include) {
        Preconditions.checkState(JsFileParser.isSupported());
        this.includeGoogBase = include;
        return this;
    }

    public JsFileParser setModuleLoader(ModuleLoader loader) {
        this.loader = loader;
        return this;
    }

    public DependencyInfo parseFile(String filePath, String closureRelativePath, String fileContents) {
        return this.parseReader(filePath, closureRelativePath, new StringReader(fileContents));
    }

    private DependencyInfo parseReader(String filePath, String closureRelativePath, Reader fileContents) {
        this.provides = new ArrayList<String>();
        this.requires = new ArrayList<DependencyInfo.Require>();
        this.typeRequires = new ArrayList<String>();
        this.fileHasProvidesOrRequires = false;
        this.file = this.loader.resolve(filePath);
        this.moduleType = ModuleType.NON_MODULE;
        this.seenLoadModule = false;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Parsing Source: " + filePath);
        }
        this.doParse(filePath, fileContents);
        if (this.moduleType == ModuleType.ES6_MODULE) {
            this.provides.add(this.file.toModuleName());
        }
        LinkedHashMap<String, String> loadFlags = new LinkedHashMap<String, String>();
        switch (this.moduleType) {
            case GOOG_MODULE: {
                loadFlags.put("module", "goog");
                break;
            }
            case ES6_MODULE: {
                loadFlags.put("module", "es6");
                break;
            }
        }
        SimpleDependencyInfo dependencyInfo = SimpleDependencyInfo.builder(closureRelativePath, filePath).setProvides(this.provides).setRequires(this.requires).setTypeRequires(this.typeRequires).setLoadFlags(loadFlags).setHasExternsAnnotation(this.hasExternsAnnotation).setHasNoCompileAnnotation(this.hasNoCompileAnnotation).build();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DepInfo: " + dependencyInfo);
        }
        return dependencyInfo;
    }

    private boolean setModuleType(ModuleType type) {
        boolean googEs6ModuleConflict;
        boolean googModule;
        boolean provide = type == ModuleType.GOOG_PROVIDE || this.moduleType == ModuleType.GOOG_PROVIDE;
        boolean es6Module = type == ModuleType.ES6_MODULE || this.moduleType == ModuleType.ES6_MODULE;
        boolean bl = googModule = type == ModuleType.GOOG_MODULE || this.moduleType == ModuleType.GOOG_MODULE;
        if (googModule && provide && this.seenLoadModule) {
            this.moduleType = ModuleType.GOOG_PROVIDE;
            return true;
        }
        boolean provideGoogModuleConflict = googModule && provide && !this.seenLoadModule;
        boolean provideEs6ModuleConflict = es6Module && provide;
        boolean bl2 = googEs6ModuleConflict = (googModule || this.seenLoadModule) && es6Module;
        if (provideGoogModuleConflict || provideEs6ModuleConflict || googEs6ModuleConflict) {
            this.errorManager.report(CheckLevel.WARNING, JSError.make(ModuleLoader.MODULE_CONFLICT, this.file.toString()));
            return false;
        }
        this.moduleType = type;
        return true;
    }

    @Override
    protected boolean parseJsDocCommentLine(String line) {
        if (this.includeGoogBase && line.contains(PROVIDES_GOOG_COMMENT)) {
            this.provides.add("goog");
            return false;
        }
        if (line.contains(EXTERNS_COMMENT)) {
            this.hasExternsAnnotation = true;
            return false;
        }
        if (line.contains(NOCOMPILE_COMMENT)) {
            this.hasNoCompileAnnotation = true;
            return false;
        }
        return true;
    }

    @Override
    protected boolean parseLine(String line) throws JsFileLineParser.ParseException {
        boolean lineHasProvidesOrRequires = false;
        if (line.startsWith(BUNDLED_GOOG_MODULE_START)) {
            this.seenLoadModule = true;
        }
        if (line.contains("provide") || line.contains("require") || line.contains("module") || line.contains("addDependency") || line.contains("declareModuleId")) {
            this.googMatcher.reset(line);
            while (this.googMatcher.find()) {
                boolean isRequire;
                String methodName;
                char firstChar;
                lineHasProvidesOrRequires = true;
                if (this.includeGoogBase && !this.fileHasProvidesOrRequires) {
                    this.fileHasProvidesOrRequires = true;
                    this.requires.add(DependencyInfo.Require.BASE);
                }
                boolean isDeclareModuleNamespace = (firstChar = (methodName = this.googMatcher.group("func")).charAt(0)) == 'd';
                boolean isModule = !isDeclareModuleNamespace && firstChar == 'm';
                boolean isProvide = firstChar == 'p';
                boolean providesNamespace = isProvide || isModule || isDeclareModuleNamespace;
                boolean bl = isRequire = firstChar == 'r';
                if (isModule && !this.seenLoadModule) {
                    providesNamespace = this.setModuleType(ModuleType.GOOG_MODULE);
                }
                if (isProvide) {
                    providesNamespace = this.setModuleType(ModuleType.GOOG_PROVIDE);
                }
                if (!providesNamespace && !isRequire) continue;
                String arg = this.parseJsString(this.googMatcher.group("args"));
                if (isRequire) {
                    if ("requireType".equals(methodName)) {
                        this.typeRequires.add(arg);
                        continue;
                    }
                    if ("goog".equals(arg)) continue;
                    DependencyInfo.Require require = DependencyInfo.Require.googRequireSymbol(arg);
                    this.requires.add(require);
                    continue;
                }
                this.provides.add(arg);
            }
        }
        if (line.startsWith("import") || line.startsWith("export")) {
            this.es6Matcher.reset(line);
            while (this.es6Matcher.find()) {
                this.setModuleType(ModuleType.ES6_MODULE);
                lineHasProvidesOrRequires = true;
                String arg = this.es6Matcher.group(1);
                if (arg == null) continue;
                if (arg.startsWith("goog:")) {
                    this.requires.add(DependencyInfo.Require.googRequireSymbol(arg.substring(5)));
                    continue;
                }
                ModuleLoader.ModulePath path = this.file.resolveJsModule(arg, this.filePath, this.lineNum, this.es6Matcher.start());
                if (path == null) {
                    path = this.file.resolveModuleAsPath(arg);
                }
                this.requires.add(DependencyInfo.Require.es6Import(path.toModuleName(), arg));
            }
            if (this.moduleType != ModuleType.ES6_MODULE && ES6_EXPORT_PATTERN.matcher(line).lookingAt()) {
                this.setModuleType(ModuleType.ES6_MODULE);
            }
        }
        return !this.shortcutMode || lineHasProvidesOrRequires || CharMatcher.whitespace().matchesAllOf(line) || !line.contains(";") || line.contains("goog.setTestOnly") || line.contains("goog.module.declareLegacyNamespace");
    }

    public static boolean isSupported() {
        return true;
    }

    private static enum ModuleType {
        NON_MODULE,
        GOOG_MODULE,
        GOOG_PROVIDE,
        ES6_MODULE;

    }
}

