/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.jscomp.deps.SortedDependencies;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Es6SortedDependencies<INPUT extends DependencyInfo>
implements SortedDependencies<INPUT> {
    private final List<INPUT> userOrderedInputs = new ArrayList<INPUT>();
    private final List<INPUT> importOrderedInputs = new ArrayList<INPUT>();
    private final Set<INPUT> completedInputs = new HashSet<INPUT>();
    private final Map<String, INPUT> nonExportingInputs = new LinkedHashMap<String, INPUT>();
    private final Map<String, INPUT> exportingInputBySymbolName = new HashMap<String, INPUT>();
    private final Multimap<INPUT, INPUT> importedInputByImportingInput = LinkedHashMultimap.create();

    public Es6SortedDependencies(List<INPUT> userOrderedInputs) {
        this.userOrderedInputs.addAll(userOrderedInputs);
        this.processInputs();
    }

    @Override
    public ImmutableList<INPUT> getStrongDependenciesOf(List<INPUT> rootInputs, boolean sorted) {
        HashSet<DependencyInfo> includedInputs = new HashSet<DependencyInfo>();
        ArrayDeque<INPUT> worklist = new ArrayDeque<INPUT>(rootInputs);
        while (!worklist.isEmpty()) {
            DependencyInfo input = (DependencyInfo)worklist.pop();
            if (!includedInputs.add(input)) continue;
            for (String symbolName : input.getRequiredSymbols()) {
                DependencyInfo importedSymbolName = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedSymbolName == null) continue;
                worklist.add(importedSymbolName);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DependencyInfo input : sorted ? this.importOrderedInputs : this.userOrderedInputs) {
            if (!includedInputs.contains(input)) continue;
            builder.add(input);
        }
        return builder.build();
    }

    @Override
    public INPUT getInputProviding(String symbolName) throws SortedDependencies.MissingProvideException {
        INPUT input = this.maybeGetInputProviding(symbolName);
        if (input != null) {
            return input;
        }
        throw new SortedDependencies.MissingProvideException(symbolName);
    }

    @Override
    public ImmutableList<INPUT> getInputsWithoutProvides() {
        return ImmutableList.copyOf(this.nonExportingInputs.values());
    }

    @Override
    public ImmutableList<INPUT> getSortedStrongDependenciesOf(List<INPUT> roots) {
        return this.getStrongDependenciesOf((List)roots, true);
    }

    @Override
    public List<INPUT> getSortedWeakDependenciesOf(List<INPUT> rootInputs) {
        HashSet strongInputs = new HashSet(this.getSortedStrongDependenciesOf((List)rootInputs));
        HashSet<DependencyInfo> weakInputs = new HashSet<DependencyInfo>();
        ArrayDeque<DependencyInfo> worklist = new ArrayDeque<DependencyInfo>(strongInputs);
        while (!worklist.isEmpty()) {
            ImmutableList<String> edges;
            DependencyInfo input = (DependencyInfo)worklist.pop();
            boolean isStrong = strongInputs.contains(input);
            Iterable<String> iterable = edges = isStrong ? input.getTypeRequires() : Iterables.concat(input.getRequiredSymbols(), input.getTypeRequires());
            if (!isStrong && !weakInputs.add(input)) continue;
            for (String symbolName : edges) {
                DependencyInfo importedSymbolName = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedSymbolName == null || strongInputs.contains(importedSymbolName) || weakInputs.contains(importedSymbolName)) continue;
                worklist.add(importedSymbolName);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DependencyInfo input : this.importOrderedInputs) {
            if (!weakInputs.contains(input)) continue;
            builder.add(input);
        }
        return builder.build();
    }

    @Override
    public List<INPUT> getSortedList() {
        return Collections.unmodifiableList(this.importOrderedInputs);
    }

    @Override
    public INPUT maybeGetInputProviding(String symbol) {
        if (this.exportingInputBySymbolName.containsKey(symbol)) {
            return (INPUT)((DependencyInfo)this.exportingInputBySymbolName.get(symbol));
        }
        return (INPUT)((DependencyInfo)this.nonExportingInputs.get(ModuleNames.fileToModuleName(symbol)));
    }

    private void orderInput(INPUT input) {
        if (this.completedInputs.contains(input)) {
            return;
        }
        this.completedInputs.add(input);
        for (DependencyInfo importedInput : this.importedInputByImportingInput.get(input)) {
            this.orderInput(importedInput);
        }
        this.importOrderedInputs.add(input);
    }

    private void processInputs() {
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            ImmutableList<String> provides = userOrderedInput.getProvides();
            String firstProvide = Iterables.getFirst(provides, null);
            if (firstProvide == null || provides.size() == 1 && firstProvide.startsWith("module$") && !"es6".equals(userOrderedInput.getLoadFlags().get("module"))) {
                this.nonExportingInputs.put(ModuleNames.fileToModuleName(userOrderedInput.getName()), userOrderedInput);
            }
            for (String providedSymbolName : userOrderedInput.getProvides()) {
                this.exportingInputBySymbolName.put(providedSymbolName, userOrderedInput);
            }
        }
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            for (String symbolName : userOrderedInput.getRequiredSymbols()) {
                DependencyInfo importedInput = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedInput == null) continue;
                this.importedInputByImportingInput.put(userOrderedInput, importedInput);
            }
        }
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            this.orderInput(userOrderedInput);
        }
        this.completedInputs.clear();
        this.importedInputByImportingInput.clear();
    }
}

