/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class SortingErrorManager
implements ErrorManager {
    private final TreeSet<ErrorWithLevel> messages = new TreeSet<ErrorWithLevel>(new LeveledJSErrorComparator());
    private int originalErrorCount = 0;
    private int promotedErrorCount = 0;
    private int warningCount = 0;
    private double typedPercent = 0.0;
    ImmutableSet<ErrorReportGenerator> errorReportGenerators;

    public SortingErrorManager(Set<ErrorReportGenerator> errorReportGenerators) {
        this.errorReportGenerators = ImmutableSet.copyOf(errorReportGenerators);
    }

    @Override
    public void report(CheckLevel level, JSError error) {
        ErrorWithLevel e = new ErrorWithLevel(error, level);
        if (this.messages.add(e)) {
            if (level == CheckLevel.ERROR) {
                if (error.getType().level == CheckLevel.ERROR) {
                    ++this.originalErrorCount;
                } else {
                    ++this.promotedErrorCount;
                }
            } else if (level == CheckLevel.WARNING) {
                ++this.warningCount;
            }
        }
    }

    @Override
    public boolean hasHaltingErrors() {
        return this.originalErrorCount != 0;
    }

    @Override
    public int getErrorCount() {
        return this.originalErrorCount + this.promotedErrorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public ImmutableList<JSError> getErrors() {
        return this.filterToListOf(CheckLevel.ERROR);
    }

    @Override
    public ImmutableList<JSError> getWarnings() {
        return this.filterToListOf(CheckLevel.WARNING);
    }

    Iterable<ErrorWithLevel> getSortedDiagnostics() {
        return ImmutableList.copyOf(this.messages);
    }

    @Override
    public void setTypedPercent(double typedPercent) {
        this.typedPercent = typedPercent;
    }

    @Override
    public double getTypedPercent() {
        return this.typedPercent;
    }

    private ImmutableList<JSError> filterToListOf(CheckLevel level) {
        return this.messages.stream().filter(e -> e.level == level).map(e -> e.error).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void generateReport() {
        for (ErrorReportGenerator generator : this.errorReportGenerators) {
            generator.generateReport(this);
        }
    }

    static class ErrorWithLevel {
        final JSError error;
        final CheckLevel level;

        ErrorWithLevel(JSError error, CheckLevel level) {
            this.error = error;
            this.level = level;
        }

        public int hashCode() {
            return Objects.hash(this.level, this.error.description, this.error.sourceName, this.error.lineNumber, this.error.getCharno());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ErrorWithLevel)) {
                return false;
            }
            ErrorWithLevel e = (ErrorWithLevel)obj;
            return Objects.equals(this.level, e.level) && Objects.equals(this.error.description, e.error.description) && Objects.equals(this.error.sourceName, e.error.sourceName) && this.error.lineNumber == e.error.lineNumber && this.error.getCharno() == e.error.getCharno();
        }
    }

    static final class LeveledJSErrorComparator
    implements Comparator<ErrorWithLevel> {
        private static final int P1_LT_P2 = -1;
        private static final int P1_GT_P2 = 1;

        LeveledJSErrorComparator() {
        }

        @Override
        public int compare(ErrorWithLevel p1, ErrorWithLevel p2) {
            int charno2;
            int lineno2;
            int lineno1;
            if (p2 == null) {
                if (p1 == null) {
                    return 0;
                }
                return 1;
            }
            if (p1.level != p2.level) {
                return p2.level.compareTo(p1.level);
            }
            String source1 = p1.error.sourceName;
            String source2 = p2.error.sourceName;
            if (source1 != null && source2 != null) {
                int sourceCompare = source1.compareTo(source2);
                if (sourceCompare != 0) {
                    return sourceCompare;
                }
            } else {
                if (source1 == null && source2 != null) {
                    return -1;
                }
                if (source1 != null && source2 == null) {
                    return 1;
                }
            }
            if ((lineno1 = p1.error.lineNumber) != (lineno2 = p2.error.lineNumber)) {
                return lineno1 - lineno2;
            }
            if (lineno1 < 0 && 0 <= lineno2) {
                return -1;
            }
            if (0 <= lineno1 && lineno2 < 0) {
                return 1;
            }
            int charno1 = p1.error.getCharno();
            if (charno1 != (charno2 = p2.error.getCharno())) {
                return charno1 - charno2;
            }
            if (charno1 < 0 && 0 <= charno2) {
                return -1;
            }
            if (0 <= charno1 && charno2 < 0) {
                return 1;
            }
            return p1.error.description.compareTo(p2.error.description);
        }
    }

    public static interface ErrorReportGenerator {
        public void generateReport(SortingErrorManager var1);
    }
}

