/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.ConformanceRules;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.rhino.Node;
import com.google.protobuf.Descriptors;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@GwtIncompatible(value="com.google.protobuf")
public final class CheckConformance
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType CONFORMANCE_ERROR = DiagnosticType.error("JSC_CONFORMANCE_ERROR", "Violation: {0}{1}{2}");
    static final DiagnosticType CONFORMANCE_VIOLATION = DiagnosticType.warning("JSC_CONFORMANCE_VIOLATION", "Violation: {0}{1}{2}");
    static final DiagnosticType CONFORMANCE_POSSIBLE_VIOLATION = DiagnosticType.warning("JSC_CONFORMANCE_POSSIBLE_VIOLATION", "Possible violation: {0}{1}{2}");
    static final DiagnosticType INVALID_REQUIREMENT_SPEC = DiagnosticType.error("JSC_INVALID_REQUIREMENT_SPEC", "Invalid requirement. Reason: {0}\nRequirement spec:\n{1}");
    private final AbstractCompiler compiler;
    private final ImmutableList<Rule> rules;
    private static final ImmutableSet<String> EXTENDABLE_FIELDS = ImmutableSet.of("extends", "whitelist", "whitelist_regexp", "only_apply_to", "only_apply_to_regexp");

    CheckConformance(AbstractCompiler compiler, ImmutableList<ConformanceConfig> configs) {
        this.compiler = compiler;
        this.rules = CheckConformance.initRules(compiler, configs);
    }

    @Override
    public void process(Node externs, Node root) {
        if (!this.rules.isEmpty()) {
            NodeTraversal.traverseRoots(this.compiler, this, externs, root);
        }
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return !n.isScript() || !t.getInput().getSourceFile().isExtern();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        int len = this.rules.size();
        for (int i = 0; i < len; ++i) {
            Rule rule = (Rule)this.rules.get(i);
            rule.check(t, n);
        }
    }

    private static ImmutableList<Rule> initRules(AbstractCompiler compiler, ImmutableList<ConformanceConfig> configs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<Requirement> requirements = CheckConformance.mergeRequirements(compiler, configs);
        for (Requirement requirement : requirements) {
            Rule rule = CheckConformance.initRule(compiler, requirement);
            if (rule == null) continue;
            builder.add(rule);
        }
        return builder.build();
    }

    static List<Requirement> mergeRequirements(AbstractCompiler compiler, List<ConformanceConfig> configs) {
        ArrayList<Requirement.Builder> builders = new ArrayList<Requirement.Builder>();
        HashMap<String, Requirement.Builder> extendable = new HashMap<String, Requirement.Builder>();
        for (ConformanceConfig config : configs) {
            for (Requirement requirement : config.getRequirementList()) {
                Requirement.Builder builder = requirement.toBuilder();
                if (requirement.hasRuleId()) {
                    if (requirement.getRuleId().isEmpty()) {
                        CheckConformance.reportInvalidRequirement(compiler, requirement, "empty rule_id");
                        continue;
                    }
                    if (extendable.containsKey(requirement.getRuleId())) {
                        CheckConformance.reportInvalidRequirement(compiler, requirement, "two requirements with the same rule_id: " + requirement.getRuleId());
                        continue;
                    }
                    extendable.put(requirement.getRuleId(), builder);
                }
                if (requirement.hasExtends()) continue;
                builders.add(builder);
            }
        }
        for (ConformanceConfig config : configs) {
            for (Requirement requirement : config.getRequirementList()) {
                if (!requirement.hasExtends()) continue;
                Requirement.Builder existing = (Requirement.Builder)extendable.get(requirement.getExtends());
                if (existing == null) {
                    CheckConformance.reportInvalidRequirement(compiler, requirement, "no requirement with rule_id: " + requirement.getExtends());
                    continue;
                }
                for (Descriptors.FieldDescriptor field : requirement.getAllFields().keySet()) {
                    if (EXTENDABLE_FIELDS.contains(field.getName())) continue;
                    CheckConformance.reportInvalidRequirement(compiler, requirement, "extending rules allow only " + EXTENDABLE_FIELDS);
                }
                existing.addAllWhitelist(requirement.getWhitelistList());
                existing.addAllWhitelistRegexp(requirement.getWhitelistRegexpList());
                existing.addAllOnlyApplyTo(requirement.getOnlyApplyToList());
                existing.addAllOnlyApplyToRegexp(requirement.getOnlyApplyToRegexpList());
                existing.addAllWhitelistEntry(requirement.getWhitelistEntryList());
            }
        }
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(builders.size());
        for (Requirement.Builder builder : builders) {
            CheckConformance.removeDuplicates(builder);
            requirements.add(builder.build());
        }
        return requirements;
    }

    private static void removeDuplicates(Requirement.Builder requirement) {
        ImmutableSet<String> list1 = ImmutableSet.copyOf(requirement.getWhitelistList());
        requirement.clearWhitelist();
        requirement.addAllWhitelist(list1);
        ImmutableSet<String> list2 = ImmutableSet.copyOf(requirement.getWhitelistRegexpList());
        requirement.clearWhitelistRegexp();
        requirement.addAllWhitelistRegexp(list2);
        ImmutableSet<String> list3 = ImmutableSet.copyOf(requirement.getOnlyApplyToList());
        requirement.clearOnlyApplyTo();
        requirement.addAllOnlyApplyTo(list3);
        ImmutableSet<String> list4 = ImmutableSet.copyOf(requirement.getOnlyApplyToRegexpList());
        requirement.clearOnlyApplyToRegexp();
        requirement.addAllOnlyApplyToRegexp(list4);
    }

    private static Rule initRule(AbstractCompiler compiler, Requirement requirement) {
        try {
            switch (requirement.getType()) {
                case CUSTOM: {
                    return new ConformanceRules.CustomRuleProxy(compiler, requirement);
                }
                case BANNED_CODE_PATTERN: {
                    return new ConformanceRules.BannedCodePattern(compiler, requirement);
                }
                case BANNED_DEPENDENCY: {
                    return new ConformanceRules.BannedDependency(compiler, requirement);
                }
                case BANNED_DEPENDENCY_REGEX: {
                    return new ConformanceRules.BannedDependencyRegex(compiler, requirement);
                }
                case BANNED_NAME: 
                case BANNED_NAME_CALL: {
                    return new ConformanceRules.BannedName(compiler, requirement);
                }
                case BANNED_PROPERTY: 
                case BANNED_PROPERTY_READ: 
                case BANNED_PROPERTY_WRITE: 
                case BANNED_PROPERTY_NON_CONSTANT_WRITE: 
                case BANNED_PROPERTY_CALL: {
                    return new ConformanceRules.BannedProperty(compiler, requirement);
                }
                case RESTRICTED_NAME_CALL: {
                    return new ConformanceRules.RestrictedNameCall(compiler, requirement);
                }
                case RESTRICTED_METHOD_CALL: {
                    return new ConformanceRules.RestrictedMethodCall(compiler, requirement);
                }
                case RESTRICTED_PROPERTY_WRITE: {
                    return new ConformanceRules.RestrictedPropertyWrite(compiler, requirement);
                }
            }
            CheckConformance.reportInvalidRequirement(compiler, requirement, "unknown requirement type");
            return null;
        }
        catch (InvalidRequirementSpec e) {
            CheckConformance.reportInvalidRequirement(compiler, requirement, e.getMessage());
            return null;
        }
    }

    private static void reportInvalidRequirement(AbstractCompiler compiler, Requirement requirement, String reason) {
        compiler.report(JSError.make(INVALID_REQUIREMENT_SPEC, reason, TextFormat.printToString(requirement)));
    }

    public static class InvalidRequirementSpec
    extends Exception {
        InvalidRequirementSpec(String message) {
            super(message);
        }

        InvalidRequirementSpec(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface Rule {
        public void check(NodeTraversal var1, Node var2);
    }
}

