/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.aria.client.CheckedValue;
import com.google.gwt.aria.client.MenuitemRole;
import com.google.gwt.aria.client.MenuitemcheckboxRole;
import com.google.gwt.aria.client.MenuitemradioRole;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.safehtml.client.HasSafeHtml;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.annotations.IsSafeHtml;
import com.google.gwt.safehtml.shared.annotations.SuppressIsSafeHtmlCastCheck;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.UIObject;

public class MenuItem
extends UIObject
implements HasHTML,
HasEnabled,
HasSafeHtml {
    private static final String DEPENDENT_STYLENAME_SELECTED_ITEM = "selected";
    private static final String DEPENDENT_STYLENAME_DISABLED_ITEM = "disabled";
    private Scheduler.ScheduledCommand command;
    private MenuBar parentMenu;
    private MenuBar subMenu;
    private boolean enabled = true;
    private final MenuitemRole menurole;

    public MenuItem(SafeHtml html) {
        this(html.asString(), true, Roles.getMenuitemRole(), false);
    }

    public MenuItem(SafeHtml html, Scheduler.ScheduledCommand cmd) {
        this(html.asString(), true, cmd);
    }

    public MenuItem(SafeHtml html, MenuBar subMenu) {
        this(html.asString(), true, subMenu);
    }

    public MenuItem(@IsSafeHtml String text, boolean asHTML, Scheduler.ScheduledCommand cmd) {
        this(text, asHTML, Roles.getMenuitemRole(), false);
        this.setScheduledCommand(cmd);
    }

    public MenuItem(@IsSafeHtml String text, boolean asHTML, MenuBar subMenu) {
        this(text, asHTML, Roles.getMenuitemRole(), false);
        this.setSubMenu(subMenu);
    }

    @SuppressIsSafeHtmlCastCheck
    public MenuItem(String text, Scheduler.ScheduledCommand cmd) {
        this(text, false, Roles.getMenuitemRole(), false);
        this.setScheduledCommand(cmd);
    }

    @SuppressIsSafeHtmlCastCheck
    public MenuItem(String text, MenuBar subMenu) {
        this(text, false, Roles.getMenuitemRole(), false);
        this.setSubMenu(subMenu);
    }

    MenuItem(@IsSafeHtml String text, boolean asHTML) {
        this(text, asHTML, Roles.getMenuitemRole(), false);
    }

    public MenuItem(@IsSafeHtml String text, boolean asHTML, MenuitemRole role, boolean checked, Scheduler.ScheduledCommand cmd) {
        this(text, asHTML, role, checked);
        this.setScheduledCommand(cmd);
    }

    public MenuItem(SafeHtml html, MenuitemRole role, boolean checked, Scheduler.ScheduledCommand cmd) {
        this(html.asString(), true, role, checked, cmd);
    }

    @SuppressIsSafeHtmlCastCheck
    public MenuItem(String text, MenuitemRole role, boolean checked, Scheduler.ScheduledCommand cmd) {
        this(text, false, role, checked);
        this.setScheduledCommand(cmd);
    }

    public MenuItem(SafeHtml html, MenuitemRole role, boolean checked) {
        this(html.asString(), true, role, checked);
    }

    public void setChecked(boolean checked) {
        CheckedValue value;
        CheckedValue checkedValue = value = checked ? CheckedValue.TRUE : CheckedValue.FALSE;
        if (this.menurole instanceof MenuitemradioRole) {
            Roles.getMenuitemradioRole().setAriaCheckedState(this.getElement(), value);
        } else if (this.menurole instanceof MenuitemcheckboxRole) {
            Roles.getMenuitemcheckboxRole().setAriaCheckedState(this.getElement(), value);
        }
    }

    MenuItem(@IsSafeHtml String text, boolean asHTML, MenuitemRole role, boolean checked) {
        CheckedValue checkedValue;
        this.setElement(DOM.createTD());
        this.setSelectionStyle(false);
        this.menurole = role;
        if (asHTML) {
            this.setHTML(text);
        } else {
            this.setText(text);
        }
        this.setStyleName("gwt-MenuItem");
        this.getElement().setAttribute("id", DOM.createUniqueId());
        CheckedValue checkedValue2 = checkedValue = checked ? CheckedValue.TRUE : CheckedValue.FALSE;
        if (role instanceof MenuitemradioRole) {
            Roles.getMenuitemradioRole().set(this.getElement());
            Roles.getMenuitemradioRole().setAriaCheckedState(this.getElement(), checkedValue);
        } else if (role instanceof MenuitemcheckboxRole) {
            Roles.getMenuitemcheckboxRole().set(this.getElement());
            Roles.getMenuitemcheckboxRole().setAriaCheckedState(this.getElement(), checkedValue);
        } else {
            Roles.getMenuitemRole().set(this.getElement());
        }
    }

    @Deprecated
    public Command getCommand() {
        Command rtnVal = this.command == null ? null : (this.command instanceof Command ? (Command)this.command : new Command(){

            @Override
            public void execute() {
                if (MenuItem.this.command != null) {
                    MenuItem.this.command.execute();
                }
            }
        });
        return rtnVal;
    }

    @Override
    public String getHTML() {
        return this.getElement().getInnerHTML();
    }

    public MenuBar getParentMenu() {
        return this.parentMenu;
    }

    public Scheduler.ScheduledCommand getScheduledCommand() {
        return this.command;
    }

    public MenuBar getSubMenu() {
        return this.subMenu;
    }

    @Override
    public String getText() {
        return this.getElement().getInnerText();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated
    public void setCommand(Command cmd) {
        this.command = cmd;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.removeStyleDependentName(DEPENDENT_STYLENAME_DISABLED_ITEM);
        } else {
            this.addStyleDependentName(DEPENDENT_STYLENAME_DISABLED_ITEM);
        }
        this.enabled = enabled;
        Roles.getMenuitemRole().setAriaDisabledState(this.getElement(), !enabled);
    }

    @Override
    public void setHTML(SafeHtml html) {
        this.setHTML(html.asString());
    }

    @Override
    public void setHTML(@IsSafeHtml String html) {
        this.getElement().setInnerHTML(html);
    }

    public void setScheduledCommand(Scheduler.ScheduledCommand cmd) {
        this.command = cmd;
    }

    public void setSubMenu(MenuBar subMenu) {
        this.subMenu = subMenu;
        if (this.parentMenu != null) {
            this.parentMenu.updateSubmenuIcon(this);
        }
        if (subMenu != null) {
            FocusPanel.impl.setTabIndex(subMenu.getElement(), -1);
            Roles.getMenuitemRole().setAriaHaspopupProperty(this.getElement(), true);
            this.setAriaExpanded(false);
        } else {
            Roles.getMenuitemRole().setAriaHaspopupProperty(this.getElement(), false);
        }
    }

    public void setAriaExpanded(boolean expanded) {
        if (expanded) {
            this.getElement().setAttribute("aria-expanded", "true");
        } else {
            this.getElement().removeAttribute("aria-expanded");
        }
    }

    @Override
    public void setText(String text) {
        this.getElement().setInnerText(text);
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        if (this.subMenu != null) {
            this.subMenu.setMenuItemDebugIds(baseID);
        }
    }

    protected void setSelectionStyle(boolean selected) {
        if (selected) {
            this.addStyleDependentName(DEPENDENT_STYLENAME_SELECTED_ITEM);
        } else {
            this.removeStyleDependentName(DEPENDENT_STYLENAME_SELECTED_ITEM);
        }
    }

    void setParentMenu(MenuBar parentMenu) {
        this.parentMenu = parentMenu;
    }
}

