/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.annotations.IsSafeHtml;
import com.google.gwt.safehtml.shared.annotations.SuppressIsSafeHtmlCastCheck;
import com.google.gwt.safehtml.shared.annotations.SuppressIsSafeUriCastCheck;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DirectionalTextHelper;
import com.google.gwt.user.client.ui.HasDirectionalSafeHtml;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.HyperlinkImpl;

public class Hyperlink
extends Widget
implements HasHTML,
SourcesClickEvents,
HasClickHandlers,
HasDirectionEstimator,
HasDirectionalSafeHtml {
    public static final DirectionEstimator DEFAULT_DIRECTION_ESTIMATOR = DirectionalTextHelper.DEFAULT_DIRECTION_ESTIMATOR;
    private static HyperlinkImpl impl = (HyperlinkImpl)GWT.create(HyperlinkImpl.class);
    protected final DirectionalTextHelper directionalTextHelper;
    private final Element anchorElem = DOM.createAnchor();
    private String targetHistoryToken;

    public Hyperlink() {
        this(DOM.createDiv());
    }

    public Hyperlink(SafeHtml html, String targetHistoryToken) {
        this(html.asString(), true, targetHistoryToken);
    }

    public Hyperlink(SafeHtml html, HasDirection.Direction dir, String targetHistoryToken) {
        this(html.asString(), true, dir, targetHistoryToken);
    }

    public Hyperlink(SafeHtml html, DirectionEstimator directionEstimator, String targetHistoryToken) {
        this(html.asString(), true, directionEstimator, targetHistoryToken);
    }

    @SuppressIsSafeHtmlCastCheck
    public Hyperlink(String text, String targetHistoryToken) {
        this(text, false, targetHistoryToken);
    }

    @SuppressIsSafeHtmlCastCheck
    public Hyperlink(String text, HasDirection.Direction dir, String targetHistoryToken) {
        this(text, false, dir, targetHistoryToken);
    }

    @SuppressIsSafeHtmlCastCheck
    public Hyperlink(String text, DirectionEstimator directionEstimator, String targetHistoryToken) {
        this(text, false, directionEstimator, targetHistoryToken);
    }

    public Hyperlink(@IsSafeHtml String text, boolean asHTML, String targetHistoryToken) {
        this();
        this.directionalTextHelper.setTextOrHtml(text, asHTML);
        this.setTargetHistoryToken(targetHistoryToken);
    }

    protected Hyperlink(Element elem) {
        if (elem == null) {
            this.setElement(this.anchorElem);
        } else {
            this.setElement(elem);
            DOM.appendChild(this.getElement(), this.anchorElem);
        }
        this.sinkEvents(1);
        this.setStyleName("gwt-Hyperlink");
        this.directionalTextHelper = new DirectionalTextHelper(this.anchorElem, true);
    }

    private Hyperlink(@IsSafeHtml String text, boolean asHTML, HasDirection.Direction dir, String targetHistoryToken) {
        this();
        this.directionalTextHelper.setTextOrHtml(text, dir, asHTML);
        this.setTargetHistoryToken(targetHistoryToken);
    }

    private Hyperlink(@IsSafeHtml String text, boolean asHTML, DirectionEstimator directionEstimator, String targetHistoryToken) {
        this();
        this.directionalTextHelper.setDirectionEstimator(directionEstimator);
        this.directionalTextHelper.setTextOrHtml(text, asHTML);
        this.setTargetHistoryToken(targetHistoryToken);
    }

    @Override
    @Deprecated
    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addHandler(handler, ClickEvent.getType());
    }

    @Override
    @Deprecated
    public void addClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.add(this, listener);
    }

    @Override
    public DirectionEstimator getDirectionEstimator() {
        return this.directionalTextHelper.getDirectionEstimator();
    }

    @Override
    public String getHTML() {
        return this.directionalTextHelper.getHtml();
    }

    public String getTargetHistoryToken() {
        return this.targetHistoryToken;
    }

    @Override
    public String getText() {
        return this.directionalTextHelper.getText();
    }

    @Override
    public HasDirection.Direction getTextDirection() {
        return this.directionalTextHelper.getTextDirection();
    }

    @Override
    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        if (DOM.eventGetType(event) == 1 && impl.handleAsClick(event)) {
            History.newItem(this.getTargetHistoryToken());
            event.preventDefault();
        }
    }

    @Override
    @Deprecated
    public void removeClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.remove(this, listener);
    }

    @Override
    public void setDirectionEstimator(boolean enabled) {
        this.directionalTextHelper.setDirectionEstimator(enabled);
    }

    @Override
    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.directionalTextHelper.setDirectionEstimator(directionEstimator);
    }

    @Override
    public void setHTML(SafeHtml html) {
        this.setHTML(html.asString());
    }

    @Override
    public void setHTML(@IsSafeHtml String html) {
        this.directionalTextHelper.setHtml(html);
    }

    @Override
    public void setHTML(SafeHtml html, HasDirection.Direction dir) {
        this.directionalTextHelper.setHtml(html, dir);
    }

    @SuppressIsSafeUriCastCheck
    public void setTargetHistoryToken(String targetHistoryToken) {
        assert (targetHistoryToken != null) : "targetHistoryToken must not be null, consider using Anchor instead";
        this.targetHistoryToken = targetHistoryToken;
        String hash = History.encodeHistoryToken(targetHistoryToken);
        this.anchorElem.setPropertyString("href", "#" + hash);
    }

    @Override
    public void setText(String text) {
        this.directionalTextHelper.setText(text);
    }

    @Override
    public void setText(String text, HasDirection.Direction dir) {
        this.directionalTextHelper.setText(text, dir);
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        Hyperlink.ensureDebugId(this.anchorElem, "", baseID);
        Hyperlink.ensureDebugId(this.getElement(), baseID, "wrapper");
    }
}

