/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.release.Changelog;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.mustache.TemplateContext;

public final class GitlabReleaser
extends BaseReleaser<org.jreleaser.model.api.release.GitlabReleaser, GitlabReleaser> {
    private static final long serialVersionUID = 8626675568115866407L;
    private final Map<String, String> uploadLinks = new LinkedHashMap<String, String>();
    private String projectIdentifier;
    @JsonIgnore
    private final org.jreleaser.model.api.release.GitlabReleaser immutable = new org.jreleaser.model.api.release.GitlabReleaser(){
        private static final long serialVersionUID = 6362243270119328338L;

        public boolean isPrerelease() {
            return GitlabReleaser.this.isPrerelease();
        }

        public String getIdentifier() {
            return this.getProjectIdentifier();
        }

        public String getProjectIdentifier() {
            return GitlabReleaser.this.projectIdentifier;
        }

        public Map<String, String> getUploadLinks() {
            return Collections.unmodifiableMap(GitlabReleaser.this.uploadLinks);
        }

        public String getServiceName() {
            return GitlabReleaser.this.getServiceName();
        }

        public boolean isReleaseSupported() {
            return GitlabReleaser.this.isReleaseSupported();
        }

        public String getCanonicalRepoName() {
            return GitlabReleaser.this.getCanonicalRepoName();
        }

        public String getReverseRepoHost() {
            return GitlabReleaser.this.getReverseRepoHost();
        }

        public boolean isMatch() {
            return GitlabReleaser.this.isMatch();
        }

        public String getHost() {
            return GitlabReleaser.this.getHost();
        }

        public String getName() {
            return GitlabReleaser.this.getName();
        }

        public String getRepoUrl() {
            return GitlabReleaser.this.getRepoUrl();
        }

        public String getRepoCloneUrl() {
            return GitlabReleaser.this.getRepoCloneUrl();
        }

        public String getCommitUrl() {
            return GitlabReleaser.this.getCommitUrl();
        }

        public String getSrcUrl() {
            return GitlabReleaser.this.getSrcUrl();
        }

        public String getDownloadUrl() {
            return GitlabReleaser.this.getDownloadUrl();
        }

        public String getReleaseNotesUrl() {
            return GitlabReleaser.this.getReleaseNotesUrl();
        }

        public String getLatestReleaseUrl() {
            return GitlabReleaser.this.getLatestReleaseUrl();
        }

        public String getIssueTrackerUrl() {
            return GitlabReleaser.this.getIssueTrackerUrl();
        }

        public String getUsername() {
            return GitlabReleaser.this.getUsername();
        }

        public String getToken() {
            return GitlabReleaser.this.getToken();
        }

        public String getTagName() {
            return GitlabReleaser.this.getTagName();
        }

        public String getPreviousTagName() {
            return GitlabReleaser.this.getPreviousTagName();
        }

        public String getReleaseName() {
            return GitlabReleaser.this.getReleaseName();
        }

        public String getBranch() {
            return GitlabReleaser.this.getBranch();
        }

        public String getBranchPush() {
            return GitlabReleaser.this.getBranchPush();
        }

        public Releaser.Prerelease getPrerelease() {
            return GitlabReleaser.this.getPrerelease().asImmutable();
        }

        public boolean isSign() {
            return GitlabReleaser.this.isSign();
        }

        public Changelog getChangelog() {
            return GitlabReleaser.this.getChangelog().asImmutable();
        }

        public Releaser.Milestone getMilestone() {
            return GitlabReleaser.this.getMilestone().asImmutable();
        }

        public Releaser.Issues getIssues() {
            return GitlabReleaser.this.getIssues().asImmutable();
        }

        public boolean isSkipTag() {
            return GitlabReleaser.this.isSkipTag();
        }

        public boolean isSkipRelease() {
            return GitlabReleaser.this.isSkipRelease();
        }

        public boolean isOverwrite() {
            return GitlabReleaser.this.isOverwrite();
        }

        public Releaser.Update getUpdate() {
            return GitlabReleaser.this.getUpdate().asImmutable();
        }

        public String getApiEndpoint() {
            return GitlabReleaser.this.getApiEndpoint();
        }

        public boolean isArtifacts() {
            return GitlabReleaser.this.isArtifacts();
        }

        public boolean isFiles() {
            return GitlabReleaser.this.isFiles();
        }

        public boolean isChecksums() {
            return GitlabReleaser.this.isChecksums();
        }

        public boolean isCatalogs() {
            return GitlabReleaser.this.isCatalogs();
        }

        public boolean isSignatures() {
            return GitlabReleaser.this.isSignatures();
        }

        public Active getUploadAssets() {
            return GitlabReleaser.this.getUploadAssets();
        }

        public CommitAuthor getCommitAuthor() {
            return GitlabReleaser.this.getCommitAuthor().asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GitlabReleaser.this.asMap(full));
        }

        public boolean isEnabled() {
            return GitlabReleaser.this.isEnabled();
        }

        public String getOwner() {
            return GitlabReleaser.this.getOwner();
        }

        public Integer getConnectTimeout() {
            return GitlabReleaser.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return GitlabReleaser.this.getReadTimeout();
        }
    };

    public GitlabReleaser() {
        super("gitlab", true);
        this.setHost("gitlab.com");
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/blob/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/releases/{{tagName}}/downloads/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/releases/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/releases/permalink/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/-/issues");
    }

    @Override
    public org.jreleaser.model.api.release.GitlabReleaser asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GitlabReleaser source) {
        super.merge(source);
        this.projectIdentifier = this.merge(this.projectIdentifier, source.projectIdentifier);
        this.setUploadLinks(this.merge(this.uploadLinks, source.uploadLinks));
    }

    @Override
    public String getReverseRepoHost() {
        return "com.gitlab";
    }

    @Deprecated
    @JsonPropertyDescription(value="gitlab.identifier is deprecated since 1.2.0 and will be removed in 2.0.0. Use gitlab.projectIdentifier instead")
    public String getIdentifier() {
        return this.getProjectIdentifier();
    }

    @Deprecated
    public void setIdentifier(String identifier) {
        JReleaserOutput.nag((String)"gitlab.identifier is deprecated since 1.2.0 and will be removed in 2.0.0. Use gitlab.projectIdentifier instead");
        this.setProjectIdentifier(identifier);
    }

    public String getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public void setProjectIdentifier(String projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
    }

    public Map<String, String> getUploadLinks() {
        return this.uploadLinks;
    }

    public void setUploadLinks(Map<String, String> uploadLinks) {
        this.uploadLinks.clear();
        this.uploadLinks.putAll(uploadLinks);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("projectIdentifier", this.projectIdentifier);
        map.put("uploadLinks", this.uploadLinks);
        return map;
    }

    @Override
    public TemplateContext props(JReleaserContext context) {
        TemplateContext props = super.props(context);
        props.set("identifier", (Object)this.projectIdentifier);
        props.set("projectIdentifier", (Object)this.projectIdentifier);
        return props;
    }
}

